/*
 * Decompiled with CFR 0.152.
 */
package sereneseasons.season;

import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_3532;
import net.minecraft.class_4538;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import sereneseasons.api.season.Season;
import sereneseasons.api.season.SeasonHelper;
import sereneseasons.init.ModConfig;
import sereneseasons.init.ModTags;
import sereneseasons.season.SeasonTime;

public class SeasonHooks {
    public static boolean shouldSnowHook(class_1959 biome, class_4538 levelReader, class_2338 pos, int seaLevel) {
        class_2680 blockstate;
        if (ModConfig.seasons.generateSnowAndIce && SeasonHooks.warmEnoughToRainSeasonal(levelReader, pos, seaLevel) || !ModConfig.seasons.generateSnowAndIce && biome.method_39927(pos, seaLevel)) {
            return false;
        }
        return levelReader.method_62871(pos.method_10264()) && levelReader.method_8314(class_1944.field_9282, pos) < 10 && (blockstate = levelReader.method_8320(pos)).method_26215() && class_2246.field_10477.method_9564().method_26184(levelReader, pos);
    }

    public static boolean shouldFreezeWarmEnoughToRainHook(class_1959 biome, class_2338 pos, int seaLevel, class_4538 levelReader) {
        return ModConfig.seasons.generateSnowAndIce && SeasonHooks.warmEnoughToRainSeasonal(levelReader, pos, seaLevel) || !ModConfig.seasons.generateSnowAndIce && biome.method_39927(pos, seaLevel);
    }

    public static boolean isRainingAtHook(class_1937 level, class_2338 position) {
        if (!level.method_8419()) {
            return false;
        }
        if (!level.method_8311(position)) {
            return false;
        }
        if (level.method_8598(class_2902.class_2903.field_13197, position).method_10264() > position.method_10264()) {
            return false;
        }
        class_6880 biome = level.method_23753(position);
        if (ModConfig.seasons.isDimensionWhitelisted((class_5321<class_1937>)level.method_27983()) && !biome.method_40220(ModTags.Biomes.BLACKLISTED_BIOMES)) {
            return SeasonHooks.getPrecipitationAtSeasonal(level, (class_6880<class_1959>)biome, position, level.method_8615()) == class_1959.class_1963.field_9382 && SeasonHooks.warmEnoughToRainSeasonal((class_4538)level, (class_6880<class_1959>)biome, position, level.method_8615());
        }
        return ((class_1959)biome.comp_349()).method_48162(position, level.method_8615()) == class_1959.class_1963.field_9382 && ((class_1959)biome.comp_349()).method_21740(position, level.method_8615()) >= 0.15f;
    }

    public static class_1959.class_1963 getPrecipitationAtTickIceAndSnowHook(class_4538 level, class_1959 biome, class_2338 pos, int seaLevel) {
        if (!biome.method_48163()) {
            return class_1959.class_1963.field_9384;
        }
        boolean shouldSnow = ModConfig.seasons.generateSnowAndIce && SeasonHooks.coldEnoughToSnowSeasonal(level, pos, seaLevel) || !ModConfig.seasons.generateSnowAndIce && biome.method_33599(pos, seaLevel);
        return shouldSnow ? class_1959.class_1963.field_9383 : class_1959.class_1963.field_9382;
    }

    public static boolean coldEnoughToSnowSeasonal(class_4538 level, class_2338 pos, int seaLevel) {
        return SeasonHooks.coldEnoughToSnowSeasonal(level, (class_6880<class_1959>)level.method_23753(pos), pos, seaLevel);
    }

    public static boolean coldEnoughToSnowSeasonal(class_4538 level, class_6880<class_1959> biome, class_2338 pos, int seaLevel) {
        return !SeasonHooks.warmEnoughToRainSeasonal(level, biome, pos, seaLevel);
    }

    public static boolean warmEnoughToRainSeasonal(class_4538 level, class_2338 pos, int seaLevel) {
        return SeasonHooks.warmEnoughToRainSeasonal(level, (class_6880<class_1959>)level.method_23753(pos), pos, seaLevel);
    }

    public static boolean warmEnoughToRainSeasonal(class_4538 level, class_6880<class_1959> biome, class_2338 pos, int seaLevel) {
        return SeasonHooks.getBiomeTemperature(level, biome, pos, seaLevel) >= 0.15f;
    }

    public static float getBiomeTemperature(class_4538 level, class_6880<class_1959> biome, class_2338 pos, int seaLevel) {
        if (!(level instanceof class_1937)) {
            return ((class_1959)biome.comp_349()).method_21740(pos, seaLevel);
        }
        return SeasonHooks.getBiomeTemperature((class_1937)level, biome, pos, seaLevel);
    }

    public static float getBiomeTemperature(class_1937 level, class_6880<class_1959> biome, class_2338 pos, int seaLevel) {
        if (!ModConfig.seasons.isDimensionWhitelisted((class_5321<class_1937>)level.method_27983()) || biome.method_40220(ModTags.Biomes.BLACKLISTED_BIOMES)) {
            return ((class_1959)biome.comp_349()).method_21740(pos, seaLevel);
        }
        return SeasonHooks.getBiomeTemperatureInSeason(new SeasonTime(SeasonHelper.getSeasonState(level).getSeasonCycleTicks()).getSubSeason(), biome, pos, seaLevel);
    }

    public static float getBiomeTemperatureInSeason(Season.SubSeason subSeason, class_6880<class_1959> biome, class_2338 pos, int seaLevel) {
        boolean tropicalBiome = biome.method_40220(ModTags.Biomes.TROPICAL_BIOMES);
        float biomeTemp = ((class_1959)biome.comp_349()).method_21740(pos, seaLevel);
        if (!tropicalBiome && ((class_1959)biome.comp_349()).method_8712() <= 0.8f && !biome.method_40220(ModTags.Biomes.BLACKLISTED_BIOMES)) {
            biomeTemp = class_3532.method_15363((float)(biomeTemp + ModConfig.seasons.getSeasonProperties(subSeason).biomeTempAdjustment()), (float)-0.5f, (float)2.0f);
        }
        return biomeTemp;
    }

    public static boolean hasPrecipitationSeasonal(class_1937 level, class_6880<class_1959> biome) {
        if (biome.method_40220(ModTags.Biomes.TROPICAL_BIOMES)) {
            Season.TropicalSeason tropicalSeason = SeasonHelper.getSeasonState(level).getTropicalSeason();
            switch (tropicalSeason) {
                case MID_DRY: {
                    return false;
                }
                case MID_WET: {
                    return true;
                }
            }
        }
        return ((class_1959)biome.comp_349()).method_48163();
    }

    public static class_1959.class_1963 getPrecipitationAtSeasonal(class_1937 level, class_6880<class_1959> biome, class_2338 pos, int seaLevel) {
        if (!SeasonHooks.hasPrecipitationSeasonal(level, biome)) {
            return class_1959.class_1963.field_9384;
        }
        return SeasonHooks.coldEnoughToSnowSeasonal((class_4538)level, biome, pos, seaLevel) ? class_1959.class_1963.field_9383 : class_1959.class_1963.field_9382;
    }
}

