/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render.glObject.texture;

import com.seibel.distanthorizons.api.interfaces.override.rendering.IDhApiFramebuffer;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftGLWrapper;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import org.lwjgl.opengl.GL32;

public class DhFramebuffer
implements IDhApiFramebuffer {
    private static final IMinecraftGLWrapper GLMC = SingletonInjector.INSTANCE.get(IMinecraftGLWrapper.class);
    private final Int2IntMap attachments;
    private final int maxDrawBuffers;
    private final int maxColorAttachments;
    private boolean hasDepthAttachment;
    private int id;

    public DhFramebuffer() {
        this.id = GL32.glGenFramebuffers();
        this.attachments = new Int2IntArrayMap();
        this.maxDrawBuffers = GL32.glGetInteger((int)34852);
        this.maxColorAttachments = GL32.glGetInteger((int)36063);
        this.hasDepthAttachment = false;
    }

    public DhFramebuffer(int id) {
        this.id = id;
        this.attachments = new Int2IntArrayMap();
        this.maxDrawBuffers = GL32.glGetInteger((int)34852);
        this.maxColorAttachments = GL32.glGetInteger((int)36063);
        this.hasDepthAttachment = false;
    }

    @Override
    public void addDepthAttachment(int textureId, boolean isCombinedStencil) {
        this.bind();
        int depthAttachment = isCombinedStencil ? 33306 : 36096;
        GL32.glFramebufferTexture2D((int)36160, (int)depthAttachment, (int)3553, (int)textureId, (int)0);
        this.hasDepthAttachment = true;
    }

    @Override
    public void addColorAttachment(int textureIndex, int textureId) {
        this.bind();
        GL32.glFramebufferTexture2D((int)36160, (int)(36064 + textureIndex), (int)3553, (int)textureId, (int)0);
        this.attachments.put(textureIndex, textureId);
    }

    public void noDrawBuffers() {
        this.bind();
        GL32.glDrawBuffers((int[])new int[]{0});
    }

    public void drawBuffers(int[] buffers) {
        int[] glBuffers = new int[buffers.length];
        int index = 0;
        if (buffers.length > this.maxDrawBuffers) {
            throw new IllegalArgumentException("Cannot write to more than " + this.maxDrawBuffers + " draw buffers on this GPU");
        }
        for (int buffer : buffers) {
            if (buffer >= this.maxColorAttachments) {
                throw new IllegalArgumentException("Only " + this.maxColorAttachments + " color attachments are supported on this GPU, but an attempt was made to write to a color attachment with index " + buffer);
            }
            glBuffers[index++] = 36064 + buffer;
        }
        this.bind();
        GL32.glDrawBuffers((int[])new int[]{0});
    }

    public void readBuffer(int buffer) {
        this.bind();
        GL32.glReadBuffer((int)(36064 + buffer));
    }

    public int getColorAttachment(int index) {
        return this.attachments.get(index);
    }

    public boolean hasDepthAttachment() {
        return this.hasDepthAttachment;
    }

    @Override
    public void bind() {
        if (this.id == -1) {
            throw new IllegalStateException("Framebuffer does not exist!");
        }
        GLMC.glBindFramebuffer(36160, this.id);
    }

    public void bindAsReadBuffer() {
        GLMC.glBindFramebuffer(36008, this.id);
    }

    public void bindAsDrawBuffer() {
        GLMC.glBindFramebuffer(36009, this.id);
    }

    @Override
    public void destroy() {
        GL32.glDeleteFramebuffers((int)this.id);
        this.id = -1;
    }

    @Override
    public int getStatus() {
        this.bind();
        int status = GL32.glCheckFramebufferStatus((int)36160);
        return status;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public boolean overrideThisFrame() {
        return true;
    }
}

