/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.worldGeneration;

import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiDistantGeneratorMode;
import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiWorldGenerationStep;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.util.objects.EventTimer;
import com.seibel.distanthorizons.core.util.objects.UncheckedInterruptedException;
import com.seibel.distanthorizons.core.util.threading.ThreadPoolUtil;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.worldGeneration.BatchGenerationEnvironment;
import loaderCommon.neoforge.com.seibel.distanthorizons.common.wrappers.worldGeneration.ThreadedParameters;
import org.apache.logging.log4j.Logger;

public final class GenerationEvent {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger(MethodHandles.lookup().lookupClass().getSimpleName());
    private static int generationFutureDebugIDs = 0;
    public final int id;
    public final ThreadedParameters threadedParam;
    public final DhChunkPos minPos;
    public final int size;
    public final EDhApiWorldGenerationStep targetGenerationStep;
    public final EDhApiDistantGeneratorMode generatorMode;
    public EventTimer timer = null;
    public long inQueueTime = System.nanoTime();
    public long timeoutTime = -1L;
    public CompletableFuture<Void> future = null;
    public final Consumer<IChunkWrapper> resultConsumer;

    public GenerationEvent(DhChunkPos minPos, int size, BatchGenerationEnvironment generationGroup, EDhApiDistantGeneratorMode generatorMode, EDhApiWorldGenerationStep targetGenerationStep, Consumer<IChunkWrapper> resultConsumer) {
        this.id = generationFutureDebugIDs++;
        this.minPos = minPos;
        this.size = size;
        this.generatorMode = generatorMode;
        this.targetGenerationStep = targetGenerationStep;
        this.threadedParam = ThreadedParameters.getOrMake(generationGroup.params);
        this.resultConsumer = resultConsumer;
    }

    public static GenerationEvent startEvent(DhChunkPos minPos, int size, BatchGenerationEnvironment genEnvironment, EDhApiDistantGeneratorMode generatorMode, EDhApiWorldGenerationStep target, Consumer<IChunkWrapper> resultConsumer, ExecutorService worldGeneratorThreadPool) {
        GenerationEvent generationEvent = new GenerationEvent(minPos, size, genEnvironment, generatorMode, target, resultConsumer);
        generationEvent.future = CompletableFuture.supplyAsync(() -> {
            long runStartTime;
            generationEvent.timeoutTime = runStartTime = System.nanoTime();
            generationEvent.inQueueTime = runStartTime - generationEvent.inQueueTime;
            generationEvent.timer = new EventTimer("setup");
            BatchGenerationEnvironment.isDistantGeneratorThread.set(true);
            try {
                genEnvironment.generateLodFromListAsync(generationEvent, runnable -> worldGeneratorThreadPool.execute(() -> {
                    boolean alreadyMarked = BatchGenerationEnvironment.isCurrentThreadDistantGeneratorThread();
                    if (!alreadyMarked) {
                        BatchGenerationEnvironment.isDistantGeneratorThread.set(true);
                    }
                    try {
                        runnable.run();
                    }
                    catch (Throwable throwable) {
                        GenerationEvent.handleWorldGenThrowable(generationEvent, throwable);
                    }
                    finally {
                        if (!alreadyMarked) {
                            BatchGenerationEnvironment.isDistantGeneratorThread.set(false);
                        }
                    }
                }));
            }
            catch (Throwable initialThrowable) {
                GenerationEvent.handleWorldGenThrowable(generationEvent, initialThrowable);
            }
            finally {
                BatchGenerationEnvironment.isDistantGeneratorThread.remove();
            }
            return null;
        }, worldGeneratorThreadPool);
        return generationEvent;
    }

    private static void handleWorldGenThrowable(GenerationEvent generationEvent, Throwable initialThrowable) {
        Throwable throwable = initialThrowable;
        while (throwable instanceof CompletionException) {
            throwable = throwable.getCause();
        }
        if (!(throwable instanceof InterruptedException || throwable instanceof UncheckedInterruptedException || throwable instanceof RejectedExecutionException)) {
            generationEvent.future.completeExceptionally(throwable);
        }
    }

    public boolean isComplete() {
        return this.future.isDone();
    }

    public boolean hasTimeout(int duration, TimeUnit unit) {
        if (this.timeoutTime == -1L) {
            return false;
        }
        long currentTime = System.nanoTime();
        long delta = currentTime - this.timeoutTime;
        return delta > TimeUnit.NANOSECONDS.convert(duration, unit);
    }

    public boolean terminate() {
        LOGGER.info("======================DUMPING ALL THREADS FOR WORLD GEN=======================");
        ThreadPoolUtil.WORLD_GEN_THREAD_FACTORY.dumpAllThreadStacks();
        this.future.cancel(true);
        return this.future.isCancelled();
    }

    public void refreshTimeout() {
        this.timeoutTime = System.nanoTime();
        UncheckedInterruptedException.throwIfInterrupted();
    }

    public String toString() {
        return this.id + ":" + this.size + "@" + String.valueOf(this.minPos) + "(" + String.valueOf((Object)this.targetGenerationStep) + ")";
    }
}

