/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.fluid;

import juuxel.adorn.fluid.FluidUnit;
import juuxel.adorn.fluid.FluidVolume;
import juuxel.adorn.fluid.HasFluidAmount;
import net.minecraft.class_3612;
import net.minecraft.class_9326;

public interface FluidAmountPredicate {
    public HasFluidAmount getUpperBound();

    public boolean test(long var1, FluidUnit var3);

    public static FluidAmountPredicate exactly(final long amount, final FluidUnit unit) {
        return new FluidAmountPredicate(){
            private final FluidVolume upperBound;
            {
                this.upperBound = new FluidVolume(class_3612.field_15906, amount, class_9326.field_49588, unit);
            }

            @Override
            public HasFluidAmount getUpperBound() {
                return this.upperBound;
            }

            @Override
            public boolean test(long amount2, FluidUnit unit2) {
                return FluidUnit.compareVolumes(amount2, unit2, this.upperBound.getAmount(), this.upperBound.getUnit()) == 0;
            }
        };
    }

    public static FluidAmountPredicate atMost(final long max, final FluidUnit unit) {
        return new FluidAmountPredicate(){
            private final FluidVolume upperBound;
            {
                this.upperBound = new FluidVolume(class_3612.field_15906, max, class_9326.field_49588, unit);
            }

            @Override
            public HasFluidAmount getUpperBound() {
                return this.upperBound;
            }

            @Override
            public boolean test(long amount, FluidUnit unit2) {
                return FluidUnit.compareVolumes(amount, unit2, this.upperBound.getAmount(), this.upperBound.getUnit()) <= 0;
            }
        };
    }
}

