/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.item;

import com.mojang.serialization.Codec;
import java.lang.invoke.LambdaMetafactory;
import java.util.function.Consumer;
import juuxel.adorn.component.AdornComponentTypes;
import juuxel.adorn.fluid.FluidUnit;
import juuxel.adorn.fluid.StepMaximum;
import juuxel.adorn.item.ItemWithDescription;
import juuxel.adorn.lib.AdornSounds;
import juuxel.adorn.platform.FluidBridge;
import juuxel.adorn.util.Colors;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2263;
import net.minecraft.class_2338;
import net.minecraft.class_2344;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3959;
import net.minecraft.class_4538;
import net.minecraft.class_5250;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_9299;
import net.minecraft.class_9331;
import net.minecraft.class_9473;

public final class WateringCanItem
extends ItemWithDescription {
    private static final int ITEM_BAR_STEPS = 13;
    private static final int MAX_WATER_LEVEL = 50;
    public static final int MAX_FERTILIZER_LEVEL = 32;
    private static final float WATER_LEVEL_DIVISOR = 0.02f;
    private static final int WATER_LEVELS_PER_BUCKET = 10;
    private static final StepMaximum FLUID_DRAIN_PREDICATE = new StepMaximum(0L, 1000L, 100L, FluidUnit.LITRE);

    public WateringCanItem(class_1792.class_1793 settings) {
        super(settings);
    }

    /*
     * Unable to fully structure code
     */
    public class_1269 method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        block8: {
            stack = user.method_5998(hand);
            success = false;
            hitResult = WateringCanItem.method_7872((class_1937)world, (class_1657)user, (class_3959.class_242)class_3959.class_242.field_1345);
            if (hitResult.method_17783() != class_239.class_240.field_1332) {
                return class_1269.field_5811;
            }
            waterLevel = (Integer)stack.method_58695((class_9331)AdornComponentTypes.WATER_LEVEL.get(), (Object)0);
            pos = hitResult.method_17777();
            state = world.method_8320(pos);
            block = state.method_26204();
            if (waterLevel >= 50) break block8;
            if (!(block instanceof class_2263)) ** GOTO lbl-1000
            drainable = (class_2263)block;
            if (world.method_8316(pos).method_39360((class_3611)class_3612.field_15910)) {
                drained = drainable.method_9700((class_1309)user, (class_1936)world, pos, state);
                drainable.method_32351().ifPresent((Consumer<class_3414>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$use$0(net.minecraft.class_1657 net.minecraft.class_3414 ), (Lnet/minecraft/class_3414;)V)((class_1657)user));
                if (drained.method_31574(class_1802.field_8705)) {
                    waterLevel = Math.min(waterLevel + 10, 50);
                    stack.method_57379((class_9331)AdornComponentTypes.WATER_LEVEL.get(), (Object)waterLevel);
                    success = true;
                }
            } else if ((drained = FluidBridge.get().drain(world, pos, null, hitResult.method_17780().method_10153(), (class_3611)class_3612.field_15910, WateringCanItem.FLUID_DRAIN_PREDICATE)) != null) {
                amount = FluidUnit.convert(drained.getAmount(), drained.getUnit(), FluidUnit.LITRE);
                levels = (int)(amount / WateringCanItem.FLUID_DRAIN_PREDICATE.getStep());
                waterLevel = Math.min(waterLevel + levels, 50);
                stack.method_57379((class_9331)AdornComponentTypes.WATER_LEVEL.get(), (Object)waterLevel);
                success = true;
                user.method_5783(class_3417.field_15126, 1.0f, 1.0f);
            }
        }
        if (!success && waterLevel > 0) {
            success = true;
            stack.method_57379((class_9331)AdornComponentTypes.WATER_LEVEL.get(), (Object)(--waterLevel));
            world.method_33596((class_1297)user, (class_6880)class_5712.field_28146, pos);
            world.method_45447((class_1297)user, pos, (class_3414)AdornSounds.ITEM_WATERING_CAN_WATER.get(), class_3419.field_15248);
            user.method_7357().method_62835(stack, 10);
            mut = new class_2338.class_2339();
            for (xo = -1; xo <= 1; ++xo) {
                for (zo = -1; zo <= 1; ++zo) {
                    mut.method_10103(pos.method_10263() + xo, pos.method_10264(), pos.method_10260() + zo);
                    this.water(world, (class_2338)mut, user, stack);
                    if (!(world instanceof class_3218)) continue;
                    serverWorld = (class_3218)world;
                    WateringCanItem.spawnParticlesAt(serverWorld, (class_2338)mut, hitResult.method_17784().field_1351);
                }
            }
        }
        return success != false ? class_1269.field_5812 : class_1269.field_5811;
    }

    private void water(class_1937 world, class_2338 pos, class_1657 player, class_1799 stack) {
        int fertilizerLevel = FertilizerLevel.get(stack);
        class_2680 state = world.method_8320(pos);
        class_2248 block = state.method_26204();
        if (fertilizerLevel > 0 && world.field_9229.method_43048(9) == 0) {
            class_2256 fertilizable;
            if (block instanceof class_2256 && (fertilizable = (class_2256)block).method_9651((class_4538)world, pos, state)) {
                if (world instanceof class_3218) {
                    class_3218 serverWorld = (class_3218)world;
                    if (fertilizable.method_9650(world, world.field_9229, pos, state)) {
                        fertilizable.method_9652(serverWorld, world.field_9229, pos, state);
                    }
                }
                world.method_8444((class_1297)player, 1505, pos, 5);
            }
            stack.method_57379((class_9331)AdornComponentTypes.FERTILIZER_LEVEL.get(), (Object)FertilizerLevel.of(fertilizerLevel - 1));
        }
        if (!world.field_9236) {
            class_2338 downPos;
            class_2680 downState;
            if (block instanceof class_2344) {
                this.waterFarmlandBlock(world, pos, state);
            } else if (!state.method_26234((class_1922)world, pos) && (downState = world.method_8320(downPos = pos.method_10074())).method_26204() instanceof class_2344) {
                this.waterFarmlandBlock(world, downPos, downState);
            }
        }
    }

    private void waterFarmlandBlock(class_1937 world, class_2338 pos, class_2680 state) {
        Integer moisture = (Integer)state.method_11654((class_2769)class_2344.field_11009);
        if (moisture < 7) {
            int moistureChange = world.field_9229.method_39332(2, 6);
            int newMoisture = Math.min(moisture + moistureChange, 7);
            world.method_8652(pos, (class_2680)state.method_11657((class_2769)class_2344.field_11009, (Comparable)Integer.valueOf(newMoisture)), 2);
        }
    }

    public boolean method_31567(class_1799 stack) {
        return true;
    }

    public int method_31569(class_1799 stack) {
        int waterLevel = class_3532.method_15340((int)((Integer)stack.method_58695((class_9331)AdornComponentTypes.WATER_LEVEL.get(), (Object)0)), (int)0, (int)50);
        return class_3532.method_48781((float)(0.02f * (float)waterLevel), (int)0, (int)13);
    }

    public int method_31571(class_1799 stack) {
        float rg = class_3532.method_37958((float)FertilizerLevel.get(stack), (float)0.0f, (float)32.0f, (float)0.4f, (float)1.0f);
        return Colors.color(rg, rg, 1.0f);
    }

    private static void spawnParticlesAt(class_3218 world, class_2338 pos, double y) {
        double px = (double)pos.method_10263() + 0.3 + world.field_9229.method_43058() * 0.4;
        double py = y + 0.1;
        double pz = (double)pos.method_10260() + 0.3 + world.field_9229.method_43058() * 0.4;
        double vx = world.field_9229.method_43058() * 0.2 - 0.1;
        double vy = 0.1;
        double vz = world.field_9229.method_43058() * 0.2 - 0.1;
        world.method_65096((class_2394)class_2398.field_11202, px, py, pz, 4, vx, vy, vz, 0.5);
    }

    private static /* synthetic */ void lambda$use$0(class_1657 user, class_3414 sound) {
        user.method_5783(sound, 1.0f, 1.0f);
    }

    public record FertilizerLevel(int level) implements class_9299
    {
        public static final Codec<FertilizerLevel> CODEC = Codec.INT.xmap(FertilizerLevel::of, FertilizerLevel::level);
        public static final FertilizerLevel ZERO = new FertilizerLevel(0);

        public static FertilizerLevel of(int level) {
            return level != 0 ? new FertilizerLevel(level) : ZERO;
        }

        public static int get(class_1799 stack) {
            return ((FertilizerLevel)stack.method_58695((class_9331)((class_9331)AdornComponentTypes.FERTILIZER_LEVEL.get()), (Object)FertilizerLevel.ZERO)).level;
        }

        public void method_57409(class_1792.class_9635 context, Consumer<class_2561> textConsumer, class_1836 type, class_9473 components) {
            class_5250 currentLevel = class_2561.method_43470((String)Integer.toString(this.level)).method_27692(class_124.field_1062);
            class_5250 maxLevel = class_2561.method_43470((String)Integer.toString(32)).method_27692(class_124.field_1062);
            textConsumer.accept((class_2561)class_2561.method_43469((String)"item.adorn.watering_can.fertilizer", (Object[])new Object[]{currentLevel, maxLevel}).method_27692(class_124.field_1080));
        }
    }
}

