/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.unlikepaladin.pfm.blocks.AbstractSittableBlock;
import com.unlikepaladin.pfm.blocks.DinnerTableBlock;
import com.unlikepaladin.pfm.blocks.DyeableFurnitureBlock;
import com.unlikepaladin.pfm.data.FurnitureBlock;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_10;
import net.minecraft.class_10225;
import net.minecraft.class_1750;
import net.minecraft.class_1767;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public class ShowerTowelBlock
extends class_2383
implements DyeableFurnitureBlock {
    private static final List<FurnitureBlock> SHOWER_TOWELS = new ArrayList<FurnitureBlock>();
    private final class_1767 color;
    public static final MapCodec<ShowerTowelBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_1767.field_41600.fieldOf("color").forGetter(towel -> towel.color), (App)ShowerTowelBlock.method_54096()).apply((Applicative)instance, ShowerTowelBlock::new));
    private static final class_265 TOWEL_SOUTH = class_259.method_17786((class_265)ShowerTowelBlock.method_9541((double)1.0, (double)1.0, (double)2.0, (double)15.0, (double)13.0, (double)5.0), (class_265[])new class_265[]{ShowerTowelBlock.method_9541((double)1.0, (double)0.0, (double)2.0, (double)15.0, (double)1.0, (double)3.0), ShowerTowelBlock.method_9541((double)0.0, (double)11.0, (double)0.0, (double)1.0, (double)12.0, (double)4.0), ShowerTowelBlock.method_9541((double)15.0, (double)11.0, (double)0.0, (double)16.0, (double)12.0, (double)4.0)});
    private static final class_265 TOWEL_NORTH = DinnerTableBlock.rotateShape(class_2350.field_11035, class_2350.field_11043, TOWEL_SOUTH);
    private static final class_265 TOWEL_EAST = DinnerTableBlock.rotateShape(class_2350.field_11035, class_2350.field_11034, TOWEL_SOUTH);
    private static final class_265 TOWEL_WEST = DinnerTableBlock.rotateShape(class_2350.field_11035, class_2350.field_11039, TOWEL_SOUTH);

    public ShowerTowelBlock(class_1767 color, class_4970.class_2251 settings) {
        super(settings);
        this.color = color;
        if (this.getClass().isAssignableFrom(ShowerTowelBlock.class)) {
            String towelColor = color.method_7792();
            SHOWER_TOWELS.add(new FurnitureBlock((class_2248)this, towelColor + "_shower_towel"));
        }
    }

    public static Stream<FurnitureBlock> streamShowerTowels() {
        return SHOWER_TOWELS.stream();
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{field_11177});
    }

    @Nullable
    public class_2680 method_9605(class_1750 ctx) {
        return (class_2680)this.method_9564().method_11657((class_2769)field_11177, (Comparable)ctx.method_8042().method_10153());
    }

    @Override
    public class_1767 getPFMColor() {
        return this.color;
    }

    public boolean method_9558(class_2680 state, class_4538 world, class_2338 pos) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)field_11177);
        class_2338 blockPos = pos.method_10093(direction.method_10153());
        class_2680 blockState = world.method_8320(blockPos);
        return blockState.method_26206((class_1922)world, blockPos, direction);
    }

    protected class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        if (direction.method_10153() == state.method_11654((class_2769)field_11177) && !state.method_26184(world, pos)) {
            return class_2246.field_10124.method_9564();
        }
        return state;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        class_2350 direction = (class_2350)state.method_11654((class_2769)field_11177);
        switch (direction) {
            case field_11043: {
                return TOWEL_NORTH;
            }
            case field_11035: {
                return TOWEL_SOUTH;
            }
            case field_11034: {
                return TOWEL_EAST;
            }
        }
        return TOWEL_WEST;
    }

    public boolean method_9516(class_2680 state, class_10 type) {
        return false;
    }

    public int getFlammability(class_2680 state, class_1922 world, class_2338 pos, class_2350 face) {
        if (AbstractSittableBlock.isWoodBased(state)) {
            return 20;
        }
        return 0;
    }

    protected MapCodec<? extends class_2383> method_53969() {
        return CODEC;
    }
}

