/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.data.materials;

import com.google.common.collect.ImmutableMap;
import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.data.materials.VariantBase;
import com.unlikepaladin.pfm.data.materials.WoodVariantRegistry;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public abstract class VariantRegistryBase<T extends VariantBase<T>> {
    private final List<VariantBase.SetFinder<T>> finders = new ArrayList<VariantBase.SetFinder<T>>();
    protected final List<T> builder = new ArrayList<T>();
    protected Map<class_2960, T> variants = new LinkedHashMap<class_2960, T>();
    private final Object2ObjectOpenHashMap<Object, T> childrenToType = new Object2ObjectOpenHashMap();

    public void addFinder(VariantBase.SetFinder<T> finder) {
        this.finders.add(finder);
    }

    protected void finalizeAndFreeze() {
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        ArrayList<String> modOrder = new ArrayList<String>();
        modOrder.add("minecraft");
        this.builder.forEach(e -> {
            String modId = e.getNamespace();
            if (!modOrder.contains(modId)) {
                modOrder.add(modId);
            }
        });
        for (String modId : modOrder) {
            this.builder.forEach(entry -> {
                if (Objects.equals(entry.getNamespace(), modId)) {
                    if (!linkedHashMap.containsKey(entry.getIdentifier())) {
                        linkedHashMap.put(entry.getIdentifier(), entry);
                    } else if (entry.getIdentifier() != WoodVariantRegistry.OAK.getIdentifier()) {
                        PaladinFurnitureMod.GENERAL_LOGGER.warn("Found block type with duplicate id ({}), skipping", (Object)entry.identifier);
                    }
                }
            });
        }
        this.variants = ImmutableMap.copyOf(linkedHashMap);
        this.builder.clear();
    }

    public void registerBlockType(T newType) {
        this.builder.add(newType);
    }

    public abstract Optional<T> getVariantFromBlock(class_2248 var1, class_2960 var2);

    public void buildAll() {
        this.registerBlockType(this.getDefaultType());
        this.finders.stream().map(VariantBase.SetFinder::get).forEach(f -> f.ifPresent(this::registerBlockType));
        for (class_2248 block : class_7923.field_41175) {
            this.getVariantFromBlock(block, class_7923.field_41175.method_10221((Object)block)).ifPresent(this::registerBlockType);
        }
        this.finalizeAndFreeze();
    }

    public void onBlockInit() {
        this.variants.values().forEach(VariantBase::initializeChildrenBlocks);
        this.variants.values().forEach(VariantBase::initializeChildrenItems);
    }

    public abstract T getDefaultType();

    public abstract Class<T> getType();

    protected void mapBlockToType(Object itemLike, VariantBase<T> type) {
        this.childrenToType.put(itemLike, (Object)((VariantBase)type.getVariantType()));
    }

    public Object2ObjectOpenHashMap<Object, T> getChildrenToType() {
        return this.childrenToType;
    }
}

