/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.data.materials;

import com.unlikepaladin.pfm.PaladinFurnitureMod;
import com.unlikepaladin.pfm.blocks.models.ModelHelper;
import com.unlikepaladin.pfm.data.materials.BlockType;
import com.unlikepaladin.pfm.data.materials.VariantBase;
import com.unlikepaladin.pfm.mixin.PFMFeatureFlagFactory;
import com.unlikepaladin.pfm.registry.BlockItemRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_7696;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class WoodVariant
extends VariantBase<WoodVariant> {
    private final class_2248 plankBlock;
    private final class_2248 logBlock;

    WoodVariant(class_2960 identifier, class_2248 plankBlock, class_2248 logBlock) {
        super(identifier);
        this.plankBlock = plankBlock;
        this.logBlock = logBlock;
    }

    public String method_15434() {
        String postfix = this.isVanilla() ? "" : "_" + this.getNamespace();
        return this.identifier.method_12832() + postfix;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_2960 getTexture(BlockType type) {
        if (type == BlockType.STRIPPED_LOG) {
            return ModelHelper.getTextureId((class_2248)this.getChild("stripped_log"));
        }
        if (type == BlockType.LOG || type == BlockType.SECONDARY) {
            return ModelHelper.getTextureId(this.logBlock);
        }
        if (type == BlockType.LOG_TOP) {
            return ModelHelper.getTextureId(this.logBlock, "_top");
        }
        if (type == BlockType.STRIPPED_LOG_TOP) {
            return ModelHelper.getTextureId((class_2248)this.getChild("stripped_log"), "_top");
        }
        return ModelHelper.getTextureId(this.plankBlock);
    }

    @Override
    public String getPath() {
        return this.identifier.method_12832();
    }

    @Nullable
    protected class_2248 findLogRelatedBlock(String append, String postpend) {
        Object post = postpend.isEmpty() ? "" : "_" + postpend;
        class_2960 id = this.getIdentifier();
        String logN = class_7923.field_41175.method_10221((Object)this.logBlock).method_12832();
        class_2960[] targets = new class_2960[]{class_2960.method_60655((String)id.method_12836(), (String)(logN + "_" + append + (String)post)), class_2960.method_60655((String)id.method_12836(), (String)(logN + "_" + append + ((String)post).replace("_", ""))), class_2960.method_60655((String)id.method_12836(), (String)(append + "_" + logN + (String)post)), class_2960.method_60655((String)id.method_12836(), (String)(append + "_" + logN + ((String)post).replace("_", ""))), class_2960.method_60655((String)id.method_12836(), (String)(id.method_12832() + "_" + append + (String)post)), class_2960.method_60655((String)id.method_12836(), (String)(id.method_12832() + "_" + append + ((String)post).replace("_", ""))), class_2960.method_60655((String)id.method_12836(), (String)(append + "_" + id.method_12832() + (String)post)), class_2960.method_60655((String)id.method_12836(), (String)(append + "_" + id.method_12832() + ((String)post).replace("_", "")))};
        Object postNether = "";
        switch (postpend) {
            case "log": {
                postNether = "stem";
                break;
            }
            case "wood": {
                postNether = "hyphae";
            }
        }
        postNether = postpend.isEmpty() ? "" : "_" + (String)postNether;
        class_2248 found = null;
        if (!((String)postNether).isEmpty()) {
            class_2960[] nether_targets;
            class_2960[] class_2960Array = nether_targets = new class_2960[]{class_2960.method_60655((String)id.method_12836(), (String)(logN + "_" + append + (String)postNether)), class_2960.method_60655((String)id.method_12836(), (String)(logN + "_" + append + ((String)postNether).replace("_", ""))), class_2960.method_60655((String)id.method_12836(), (String)(append + "_" + logN + (String)postNether)), class_2960.method_60655((String)id.method_12836(), (String)(append + "_" + logN + ((String)postNether).replace("_", ""))), class_2960.method_60655((String)id.method_12836(), (String)(id.method_12832() + "_" + append + (String)postNether)), class_2960.method_60655((String)id.method_12836(), (String)(id.method_12832() + "_" + append + ((String)postNether).replace("_", ""))), class_2960.method_60655((String)id.method_12836(), (String)(append + "_" + id.method_12832() + (String)postNether)), class_2960.method_60655((String)id.method_12836(), (String)(append + "_" + id.method_12832() + ((String)postNether).replace("_", "")))};
            int n = class_2960Array.length;
            for (int i = 0; i < n; ++i) {
                class_2960 r = class_2960Array[i];
                if (!class_7923.field_41175.method_10250(r)) continue;
                found = (class_2248)class_7923.field_41175.method_63535(r);
                break;
            }
        }
        for (class_2960 r : targets) {
            if (!class_7923.field_41175.method_10250(r)) continue;
            found = (class_2248)class_7923.field_41175.method_63535(r);
            break;
        }
        return found;
    }

    @Override
    public class_2248 getBaseBlock() {
        return this.plankBlock;
    }

    @Override
    public class_2248 getSecondaryBlock() {
        return this.logBlock;
    }

    public class_2248 getLogBlock() {
        return this.logBlock;
    }

    public String toString() {
        return this.identifier.toString();
    }

    @Override
    public boolean isNetherWood() {
        return this.identifier.method_12832().contains("warped") || this.identifier.method_12832().contains("crimson");
    }

    @Override
    public boolean isVanilla() {
        return this.identifier.method_12836().equals("") || this.identifier.method_12836().equals("minecraft");
    }

    @Override
    public WoodVariant getVariantType() {
        return this;
    }

    @Override
    public List<class_7696> getFeatureList() {
        class_7696 flag = PFMFeatureFlagFactory.newFlag(this.getBaseBlock().method_45322().field_40174, 0);
        flag.field_40164 = this.getBaseBlock().method_45322().field_40175;
        return List.of(flag);
    }

    @Override
    public void initializeChildrenBlocks() {
        this.addChild("planks", this.plankBlock);
        this.addChild("log", this.logBlock);
        this.addChild("leaves", this.findRelatedEntry("leaves", class_7923.field_41175));
        this.addChild("stripped_log", this.findLogRelatedBlock("stripped", "log"));
        this.addChild("stripped_wood", this.findLogRelatedBlock("stripped", "wood"));
        this.addChild("wood", this.findRelatedEntry("wood", class_7923.field_41175));
        this.addChild("slab", this.findRelatedEntry("slab", class_7923.field_41175));
        this.addChild("stairs", this.findRelatedEntry("stairs", class_7923.field_41175));
        this.addChild("fence", this.findRelatedEntry("fence", class_7923.field_41175));
        this.addChild("fence_gate", this.findRelatedEntry("fence_gate", class_7923.field_41175));
        this.addChild("door", this.findRelatedEntry("door", class_7923.field_41175));
        this.addChild("trapdoor", this.findRelatedEntry("trapdoor", class_7923.field_41175));
        this.addChild("button", this.findRelatedEntry("button", class_7923.field_41175));
        this.addChild("pressure_plate", this.findRelatedEntry("pressure_plate", class_7923.field_41175));
    }

    @Override
    public void initializeChildrenItems() {
        this.addChild("boat", this.findRelatedEntry("boat", class_7923.field_41178));
        this.addChild("sign", this.findRelatedEntry("sign", class_7923.field_41178));
    }

    public boolean hasStripped() {
        Object child = this.getChild("stripped_log");
        return child != null && child != this.getBaseBlock();
    }

    @Nullable
    public class_1935 getItemForRecipe(String key, Class<? extends class_2248> blockClass, boolean stripped) {
        if (stripped) {
            if (key.equals("base")) {
                return (class_1935)this.getChild("stripped_log");
            }
            if (key.equals("secondary")) {
                return this.getBaseBlock();
            }
        }
        return super.getItemForRecipe(key, blockClass);
    }

    @Override
    public class_2248 mainChild() {
        return this.plankBlock;
    }

    public static class Finder
    implements VariantBase.SetFinder<WoodVariant> {
        private final Map<String, class_2960> childNames = new HashMap<String, class_2960>();
        private final Supplier<class_2248> planksFinder;
        private final Supplier<class_2248> logFinder;
        private final class_2960 id;

        public Finder(class_2960 id, Supplier<class_2248> planks, Supplier<class_2248> log) {
            this.id = id;
            this.planksFinder = planks;
            this.logFinder = log;
        }

        public static Finder simple(String modId, String woodTypeName, String planksName, String logName) {
            return Finder.simple(class_2960.method_60655((String)modId, (String)woodTypeName), class_2960.method_60655((String)modId, (String)planksName), class_2960.method_60655((String)modId, (String)logName));
        }

        public static Finder simple(class_2960 woodTypeName, class_2960 planksName, class_2960 logName) {
            return new Finder(woodTypeName, () -> (class_2248)class_7923.field_41175.method_63535(planksName), () -> (class_2248)class_7923.field_41175.method_63535(logName));
        }

        public void addChild(String childType, String childName) {
            this.addChild(childType, class_2960.method_60655((String)this.id.method_12836(), (String)childName));
        }

        public void addChild(String childType, class_2960 childName) {
            this.childNames.put(childType, childName);
        }

        @Override
        public Optional<WoodVariant> get() {
            if (BlockItemRegistry.isModLoaded(this.id.method_12836())) {
                try {
                    class_2248 plank = this.planksFinder.get();
                    class_2248 log = this.logFinder.get();
                    class_2248 d = (class_2248)class_7923.field_41175.method_63535(class_2960.method_60655((String)"minecraft", (String)"air"));
                    if (plank != d && log != d && plank != null && log != null) {
                        WoodVariant w = new WoodVariant(this.id, plank, log);
                        for (Map.Entry<String, class_2960> entry : this.childNames.entrySet()) {
                            Object child = class_7923.field_41175.method_17966(entry.getValue()).isPresent() ? class_7923.field_41175.method_63535(entry.getValue()) : class_7923.field_41178.method_63535(entry.getValue());
                            w.addChild(entry.getKey(), child);
                        }
                        return Optional.of(w);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                PaladinFurnitureMod.GENERAL_LOGGER.warn("Failed to find custom wood type {}", (Object)this.id);
            }
            return Optional.empty();
        }
    }
}

