/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.networking;

import com.unlikepaladin.pfm.networking.ClientSyncRecipesPayloadHandler;
import com.unlikepaladin.pfm.recipes.DynamicFurnitureRecipe;
import com.unlikepaladin.pfm.recipes.FurnitureRecipe;
import com.unlikepaladin.pfm.recipes.SimpleFurnitureRecipe;
import com.unlikepaladin.pfm.registry.NetworkIDs;
import java.util.ArrayList;
import java.util.Objects;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public final class SyncRecipesPayload
implements class_8710 {
    public static final class_9139<class_9129, SyncRecipesPayload> PACKET_CODEC = class_8710.method_56484(SyncRecipesPayload::write, SyncRecipesPayload::new);
    private final ArrayList<FurnitureRecipe> recipes;

    public SyncRecipesPayload(ArrayList<FurnitureRecipe> recipes) {
        this.recipes = recipes;
    }

    public SyncRecipesPayload(class_9129 buf) {
        int recipeCount = buf.readInt();
        this.recipes = new ArrayList(recipeCount);
        for (int i = 0; i < recipeCount; ++i) {
            int j = buf.readInt();
            if (j == 0) {
                this.recipes.add(SimpleFurnitureRecipe.Serializer.read(buf));
                continue;
            }
            this.recipes.add(DynamicFurnitureRecipe.Serializer.read(buf));
        }
    }

    public class_8710.class_9154<? extends class_8710> method_56479() {
        return NetworkIDs.SYNC_FURNITURE_RECIPES;
    }

    public void write(class_9129 buf) {
        buf.method_53002(this.recipes.size());
        for (FurnitureRecipe recipe : this.recipes) {
            if (recipe instanceof DynamicFurnitureRecipe) {
                buf.method_53002(1);
                recipe.write(buf);
                continue;
            }
            buf.method_53002(0);
            recipe.write(buf);
        }
    }

    public void handle() {
        ClientSyncRecipesPayloadHandler.handlePacket(this.recipes);
    }

    public ArrayList<FurnitureRecipe> recipes() {
        return this.recipes;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        SyncRecipesPayload that = (SyncRecipesPayload)obj;
        return Objects.equals(this.recipes, that.recipes);
    }

    public int hashCode() {
        return Objects.hash(this.recipes);
    }

    public String toString() {
        return "SyncRecipesPayload[recipes=" + String.valueOf(this.recipes) + "]";
    }
}

