/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.gui.widget;

import com.mojang.blaze3d.buffers.BufferType;
import com.mojang.blaze3d.buffers.BufferUsage;
import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.terraformersmc.modmenu.api.UpdateInfo;
import com.terraformersmc.modmenu.config.ModMenuConfig;
import com.terraformersmc.modmenu.gui.ModsScreen;
import com.terraformersmc.modmenu.gui.widget.UpdateAvailableBadge;
import com.terraformersmc.modmenu.util.mod.Mod;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.Set;
import java.util.SortedMap;
import net.minecraft.class_10799;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_276;
import net.minecraft.class_287;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_407;
import net.minecraft.class_4265;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_8219;
import net.minecraft.class_9799;
import net.minecraft.class_9801;
import net.minecraft.class_9848;

public class DescriptionListWidget
extends class_350<DescriptionEntry> {
    private static final class_2561 HAS_UPDATE_TEXT = class_2561.method_43471((String)"modmenu.hasUpdate");
    private static final class_2561 EXPERIMENTAL_TEXT = class_2561.method_43471((String)"modmenu.experimental").method_27692(class_124.field_1065);
    private static final class_2561 DOWNLOAD_TEXT = class_2561.method_43471((String)"modmenu.downloadLink").method_27692(class_124.field_1078).method_27692(class_124.field_1073);
    private static final class_2561 CHILD_HAS_UPDATE_TEXT = class_2561.method_43471((String)"modmenu.childHasUpdate");
    private static final class_2561 LINKS_TEXT = class_2561.method_43471((String)"modmenu.links");
    private static final class_2561 SOURCE_TEXT = class_2561.method_43471((String)"modmenu.source").method_27692(class_124.field_1078).method_27692(class_124.field_1073);
    private static final class_2561 LICENSE_TEXT = class_2561.method_43471((String)"modmenu.license");
    private static final class_2561 VIEW_CREDITS_TEXT = class_2561.method_43471((String)"modmenu.viewCredits").method_27692(class_124.field_1078).method_27692(class_124.field_1073);
    private static final class_2561 CREDITS_TEXT = class_2561.method_43471((String)"modmenu.credits");
    private final ModsScreen parent;
    private final class_327 textRenderer;
    private Mod selectedMod = null;

    public DescriptionListWidget(class_310 client, int width, int height, int y, int itemHeight, DescriptionListWidget copyFrom, ModsScreen parent) {
        super(client, width, height, y, itemHeight);
        this.parent = parent;
        this.textRenderer = client.field_1772;
        if (copyFrom != null) {
            this.updateSelectedModIfRequired(copyFrom.selectedMod);
            this.method_44382(copyFrom.method_44387());
        }
        if (parent.getSelectedEntry() != null) {
            this.updateSelectedModIfRequired(parent.getSelectedEntry().getMod());
        }
    }

    public DescriptionEntry getSelectedOrNull() {
        return null;
    }

    public int method_25322() {
        return this.field_22758 - 10;
    }

    protected int method_65507() {
        return this.field_22758 - 6 + this.method_46426();
    }

    public void method_47399(class_6382 builder) {
        if (this.selectedMod != null) {
            builder.method_37033(class_6381.field_33788, this.selectedMod.getTranslatedName() + " " + this.selectedMod.getPrefixedVersion());
        }
    }

    private void rebuildUI() {
        block30: {
            SortedMap<String, Set<String>> credits;
            Mod mod;
            int wrapWidth;
            DescriptionEntry emptyEntry;
            block31: {
                if (this.selectedMod == null) {
                    return;
                }
                emptyEntry = new DescriptionEntry(class_5481.field_26385);
                wrapWidth = this.method_25322() - 5;
                mod = this.selectedMod;
                class_2561 description = mod.getFormattedDescription();
                if (!description.getString().isEmpty()) {
                    for (class_5481 line : this.textRenderer.method_1728((class_5348)description, wrapWidth)) {
                        this.method_25396().add(new DescriptionEntry(line));
                    }
                }
                if (ModMenuConfig.UPDATE_CHECKER.getValue() && !ModMenuConfig.DISABLE_UPDATE_CHECKER.getValue().contains(mod.getId())) {
                    Object entry;
                    UpdateInfo updateInfo = mod.getUpdateInfo();
                    if (updateInfo != null && updateInfo.isUpdateAvailable()) {
                        this.method_25396().add(emptyEntry);
                        int index = 0;
                        for (Object line : this.textRenderer.method_1728((class_5348)HAS_UPDATE_TEXT, wrapWidth - 11)) {
                            entry = new DescriptionEntry((class_5481)line);
                            if (index == 0) {
                                ((DescriptionEntry)((Object)entry)).setUpdateTextEntry();
                            }
                            this.method_25396().add(entry);
                            ++index;
                        }
                        for (Object line : this.textRenderer.method_1728((class_5348)EXPERIMENTAL_TEXT, wrapWidth - 16)) {
                            this.method_25396().add(new DescriptionEntry((class_5481)line, 8));
                        }
                        class_2561 updateMessage = updateInfo.getUpdateMessage();
                        String downloadLink = updateInfo.getDownloadLink();
                        if (updateMessage == null) {
                            updateMessage = DOWNLOAD_TEXT;
                        } else if (downloadLink != null) {
                            updateMessage = updateMessage.method_27661().method_27692(class_124.field_1078).method_27692(class_124.field_1073);
                        }
                        for (class_5481 line : this.textRenderer.method_1728((class_5348)updateMessage, wrapWidth - 16)) {
                            if (downloadLink != null) {
                                this.method_25396().add(new LinkEntry(line, downloadLink, 8));
                                continue;
                            }
                            this.method_25396().add(new DescriptionEntry(line, 8));
                        }
                    }
                    if (mod.getChildHasUpdate()) {
                        this.method_25396().add(emptyEntry);
                        int index = 0;
                        for (Object line : this.textRenderer.method_1728((class_5348)CHILD_HAS_UPDATE_TEXT, wrapWidth - 11)) {
                            entry = new DescriptionEntry((class_5481)line);
                            if (index == 0) {
                                ((DescriptionEntry)((Object)entry)).setUpdateTextEntry();
                            }
                            this.method_25396().add(entry);
                            ++index;
                        }
                    }
                }
                Map<String, String> links = mod.getLinks();
                String sourceLink = mod.getSource();
                if (!(links.isEmpty() && sourceLink == null || ModMenuConfig.HIDE_MOD_LINKS.getValue())) {
                    this.method_25396().add(emptyEntry);
                    for (Object line : this.textRenderer.method_1728((class_5348)LINKS_TEXT, wrapWidth)) {
                        this.method_25396().add(new DescriptionEntry((class_5481)line));
                    }
                    if (sourceLink != null) {
                        int indent = 8;
                        for (Object line : this.textRenderer.method_1728((class_5348)SOURCE_TEXT, wrapWidth - 16)) {
                            this.method_25396().add(new LinkEntry((class_5481)line, sourceLink, indent));
                            indent = 16;
                        }
                    }
                    links.forEach((key, value) -> {
                        int indent = 8;
                        for (class_5481 line : this.textRenderer.method_1728((class_5348)class_2561.method_43471((String)key).method_27692(class_124.field_1078).method_27692(class_124.field_1073), wrapWidth - 16)) {
                            this.method_25396().add(new LinkEntry(line, (String)value, indent));
                            indent = 16;
                        }
                    });
                }
                Set<String> licenses = mod.getLicense();
                if (!ModMenuConfig.HIDE_MOD_LICENSE.getValue() && !licenses.isEmpty()) {
                    this.method_25396().add(emptyEntry);
                    for (Object line : this.textRenderer.method_1728((class_5348)LICENSE_TEXT, wrapWidth)) {
                        this.method_25396().add(new DescriptionEntry((class_5481)line));
                    }
                    for (String license : licenses) {
                        int indent = 8;
                        for (class_5481 line : this.textRenderer.method_1728((class_5348)class_2561.method_43470((String)license), wrapWidth - 16)) {
                            this.method_25396().add(new DescriptionEntry(line, indent));
                            indent = 16;
                        }
                    }
                }
                if (ModMenuConfig.HIDE_MOD_CREDITS.getValue()) break block30;
                if (!"minecraft".equals(mod.getId())) break block31;
                this.method_25396().add(emptyEntry);
                for (Object line : this.textRenderer.method_1728((class_5348)VIEW_CREDITS_TEXT, wrapWidth)) {
                    this.method_25396().add(new MojangCreditsEntry((class_5481)line));
                }
                break block30;
            }
            if ("java".equals(mod.getId()) || (credits = mod.getCredits()).isEmpty()) break block30;
            this.method_25396().add(emptyEntry);
            for (class_5481 line : this.textRenderer.method_1728((class_5348)CREDITS_TEXT, wrapWidth)) {
                this.method_25396().add(new DescriptionEntry(line));
            }
            Iterator<Map.Entry<String, Set<String>>> iterator = credits.entrySet().iterator();
            while (iterator.hasNext()) {
                int indent = 8;
                Map.Entry<String, Set<String>> role = iterator.next();
                for (class_5481 line : this.textRenderer.method_1728((class_5348)this.creditsRoleText(role.getKey()), wrapWidth - 16)) {
                    this.method_25396().add(new DescriptionEntry(line, indent));
                    indent = 16;
                }
                for (String contributor : role.getValue()) {
                    indent = 16;
                    for (class_5481 line : this.textRenderer.method_1728((class_5348)class_2561.method_43470((String)contributor), wrapWidth - 24)) {
                        this.method_25396().add(new DescriptionEntry(line, indent));
                        indent = 24;
                    }
                }
                if (!iterator.hasNext()) continue;
                this.method_25396().add(emptyEntry);
            }
        }
    }

    public void updateSelectedModIfRequired(Mod mod) {
        if (mod != this.selectedMod) {
            this.selectedMod = mod;
            this.method_25339();
            this.method_44382(-1.7976931348623157E308);
            this.rebuildUI();
        }
    }

    public void method_25311(class_332 drawContext, int mouseX, int mouseY, float delta) {
        this.method_49603(drawContext);
        super.method_25311(drawContext, mouseX, mouseY, delta);
        drawContext.method_44380();
        RenderPipeline pipeline = class_10799.field_56879;
        try (class_9799 alloc = new class_9799(pipeline.getVertexFormat().getVertexSize() * 4);){
            class_287 bufferBuilder = new class_287(alloc, pipeline.getVertexFormatMode(), pipeline.getVertexFormat());
            int black = class_9848.method_61334((int)0);
            bufferBuilder.method_22912((float)this.method_46426(), (float)(this.method_46427() + 4), 0.0f).method_39415(0);
            bufferBuilder.method_22912((float)this.method_55442(), (float)(this.method_46427() + 4), 0.0f).method_39415(0);
            bufferBuilder.method_22912((float)this.method_55442(), (float)this.method_46427(), 0.0f).method_39415(black);
            bufferBuilder.method_22912((float)this.method_46426(), (float)this.method_46427(), 0.0f).method_39415(black);
            bufferBuilder.method_22912((float)this.method_46426(), (float)this.method_55443(), 0.0f).method_39415(black);
            bufferBuilder.method_22912((float)this.method_55442(), (float)this.method_55443(), 0.0f).method_39415(black);
            bufferBuilder.method_22912((float)this.method_55442(), (float)(this.method_55443() - 4), 0.0f).method_39415(0);
            bufferBuilder.method_22912((float)this.method_46426(), (float)(this.method_55443() - 4), 0.0f).method_39415(0);
            this.renderScrollBar(bufferBuilder);
            try (class_9801 builtBuffer = bufferBuilder.method_60794();){
                if (builtBuffer == null) {
                    alloc.close();
                    return;
                }
                class_276 framebuffer = class_310.method_1551().method_1522();
                RenderSystem.class_5590 autoStorageIndexBuffer = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)pipeline.getVertexFormatMode());
                VertexFormat.class_5595 indexType = autoStorageIndexBuffer.method_31924();
                GpuBuffer vertexBuffer = RenderSystem.getDevice().createBuffer(() -> "Description List", BufferType.VERTICES, BufferUsage.DYNAMIC_WRITE, builtBuffer.method_60818().remaining());
                GpuBuffer indexBuffer = autoStorageIndexBuffer.method_68274(builtBuffer.method_60822().comp_751());
                RenderSystem.getDevice().createCommandEncoder().writeToBuffer(vertexBuffer, builtBuffer.method_60818(), 0);
                try (RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(framebuffer.method_30277(), OptionalInt.empty(), framebuffer.method_30278(), OptionalDouble.empty());){
                    renderPass.setPipeline(pipeline);
                    renderPass.setVertexBuffer(0, vertexBuffer);
                    renderPass.setIndexBuffer(indexBuffer, indexType);
                    renderPass.drawIndexed(0, builtBuffer.method_60822().comp_751());
                }
            }
        }
    }

    public void renderScrollBar(class_287 bufferBuilder) {
        int scrollbarStartX = this.method_65507();
        int scrollbarEndX = scrollbarStartX + 6;
        int maxScroll = this.method_44390();
        if (maxScroll > 0) {
            int p = (int)((float)((this.method_55443() - this.method_46427()) * (this.method_55443() - this.method_46427())) / (float)this.method_44395());
            p = class_3532.method_15340((int)p, (int)32, (int)(this.method_55443() - this.method_46427() - 8));
            int q = (int)this.method_44387() * (this.method_55443() - this.method_46427() - p) / maxScroll + this.method_46427();
            if (q < this.method_46427()) {
                q = this.method_46427();
            }
            int black = class_9848.method_61334((int)0);
            int firstColor = class_9848.method_61318((float)255.0f, (float)128.0f, (float)128.0f, (float)128.0f);
            int lastColor = class_9848.method_61318((float)255.0f, (float)192.0f, (float)192.0f, (float)192.0f);
            bufferBuilder.method_22912((float)scrollbarStartX, (float)this.method_55443(), 0.0f).method_39415(black);
            bufferBuilder.method_22912((float)scrollbarEndX, (float)this.method_55443(), 0.0f).method_39415(black);
            bufferBuilder.method_22912((float)scrollbarEndX, (float)this.method_46427(), 0.0f).method_39415(black);
            bufferBuilder.method_22912((float)scrollbarStartX, (float)this.method_46427(), 0.0f).method_39415(black);
            bufferBuilder.method_22912((float)scrollbarStartX, (float)(q + p), 0.0f).method_39415(firstColor);
            bufferBuilder.method_22912((float)scrollbarEndX, (float)(q + p), 0.0f).method_39415(firstColor);
            bufferBuilder.method_22912((float)scrollbarEndX, (float)q, 0.0f).method_39415(firstColor);
            bufferBuilder.method_22912((float)scrollbarStartX, (float)q, 0.0f).method_39415(firstColor);
            bufferBuilder.method_22912((float)scrollbarStartX, (float)(q + p - 1), 0.0f).method_39415(lastColor);
            bufferBuilder.method_22912((float)(scrollbarEndX - 1), (float)(q + p - 1), 0.0f).method_39415(lastColor);
            bufferBuilder.method_22912((float)(scrollbarEndX - 1), (float)q, 0.0f).method_39415(lastColor);
            bufferBuilder.method_22912((float)scrollbarStartX, (float)q, 0.0f).method_39415(lastColor);
        }
    }

    private class_2561 creditsRoleText(String roleName) {
        String translationKey = roleName.replaceAll("[ -]", "_").toLowerCase();
        Object fallback = roleName.endsWith("r") ? roleName + "s" : roleName;
        return class_2561.method_48321((String)("modmenu.credits.role." + translationKey), (String)fallback).method_10852((class_2561)class_2561.method_43470((String)":"));
    }

    protected class DescriptionEntry
    extends class_4265.class_4266<DescriptionEntry> {
        protected class_5481 text;
        protected int indent;
        public boolean updateTextEntry = false;

        public DescriptionEntry(class_5481 text, int indent) {
            this.text = text;
            this.indent = indent;
        }

        public DescriptionEntry(class_5481 text) {
            this(text, 0);
        }

        public DescriptionEntry setUpdateTextEntry() {
            this.updateTextEntry = true;
            return this;
        }

        public void method_25343(class_332 drawContext, int index, int y, int x, int itemWidth, int itemHeight, int mouseX, int mouseY, boolean isSelected, float delta) {
            if (this.updateTextEntry) {
                UpdateAvailableBadge.renderBadge(drawContext, x + this.indent, y);
                x += 11;
            }
            drawContext.method_35720(DescriptionListWidget.this.textRenderer, this.text, x + this.indent, y, 0xAAAAAA);
        }

        public List<? extends class_364> method_25396() {
            return Collections.emptyList();
        }

        public List<? extends class_6379> method_37025() {
            return Collections.emptyList();
        }
    }

    protected class LinkEntry
    extends DescriptionEntry {
        private final String link;

        public LinkEntry(class_5481 text, String link, int indent) {
            super(text, indent);
            this.link = link;
        }

        public LinkEntry(class_5481 text, String link) {
            this(text, link, 0);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (this.method_25405(mouseX, mouseY)) {
                DescriptionListWidget.this.field_22740.method_1507((class_437)new class_407(open -> {
                    if (open) {
                        class_156.method_668().method_670(this.link);
                    }
                    DescriptionListWidget.this.field_22740.method_1507((class_437)DescriptionListWidget.this.parent);
                }, this.link, false));
            }
            return super.method_25402(mouseX, mouseY, button);
        }
    }

    protected class MojangCreditsEntry
    extends DescriptionEntry {
        public MojangCreditsEntry(class_5481 text) {
            super(text);
        }

        public boolean method_25402(double mouseX, double mouseY, int button) {
            if (this.method_25405(mouseX, mouseY)) {
                DescriptionListWidget.this.field_22740.method_1507((class_437)new MinecraftCredits(this));
            }
            return super.method_25402(mouseX, mouseY, button);
        }

        class MinecraftCredits
        extends class_8219 {
            public MinecraftCredits(MojangCreditsEntry this$1) {
                super((class_437)this$1.DescriptionListWidget.this.parent);
            }
        }
    }
}

