/*
 * Decompiled with CFR 0.152.
 */
package by.gdev.http.download.impl;

import by.gdev.http.download.model.Headers;
import by.gdev.http.download.model.RequestMetadata;
import by.gdev.http.download.service.FileCacheService;
import by.gdev.http.download.service.HttpService;
import by.gdev.util.DesktopUtil;
import by.gdev.util.model.InternetServerMap;
import by.gdev.util.model.download.Metadata;
import by.gdev.utils.service.FileMapperService;
import com.google.gson.Gson;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileCacheServiceImpl
implements FileCacheService {
    private static final Logger log = LoggerFactory.getLogger(FileCacheServiceImpl.class);
    private HttpService httpService;
    private Path directory;
    private int timeToLife;
    private FileMapperService fileMapperService;
    private InternetServerMap workedServers;

    public FileCacheServiceImpl(HttpService httpService, Gson gson, Charset charset, Path directory, int timeToLife, InternetServerMap workedServers) {
        this.httpService = httpService;
        this.directory = directory;
        this.timeToLife = timeToLife;
        this.fileMapperService = new FileMapperService(gson, charset, "");
        this.workedServers = workedServers;
    }

    private Path getRawObject(String url, boolean cache, Path savedPath) throws IOException, NoSuchAlgorithmException {
        Path metaFile = Paths.get(String.valueOf(savedPath).concat(".metadata"), new String[0]);
        if (cache) {
            return this.getResourceWithoutHttpHead(url, metaFile, savedPath);
        }
        return this.getResourceWithHttpHead(url, metaFile, savedPath);
    }

    @Override
    public Path getRawObject(List<String> urls, Metadata metadata, boolean cache) throws IOException, NoSuchAlgorithmException {
        String urn = metadata.getRelativeUrl();
        return this.getRawObject1(urls, urn, cache);
    }

    protected Path getRawObject1(List<String> urls, String urn, boolean cache) throws NoSuchAlgorithmException, IOException {
        IOException ex = null;
        Path savedPath = this.buildPath(urls.get(0) + urn);
        for (String url : this.workedServers.getAliveDomainsOrUseAllWithSort(urls)) {
            try {
                return this.getRawObject(url + urn, cache, savedPath);
            }
            catch (IOException e) {
                ex = e;
            }
        }
        throw ex;
    }

    @Override
    public Path getRawObject(List<String> urls, String urn, boolean cache) throws NoSuchAlgorithmException, IOException {
        return this.getRawObject1(urls, urn, cache);
    }

    @Override
    public Path getLocalRawObject(List<String> urls, Metadata metadata) throws IOException, NoSuchAlgorithmException {
        return this.readLocalRawObject(urls, metadata.getRelativeUrl());
    }

    @Override
    public Path getLocalRawObject(List<String> urls, String urn) throws IOException, NoSuchAlgorithmException {
        return this.readLocalRawObject(urls, urn);
    }

    protected Path readLocalRawObject(List<String> urls, String urn) throws IOException, NoSuchAlgorithmException {
        Path savedPath = this.buildPath(urls.get(0) + urn).toAbsolutePath();
        Path metaFile = Paths.get(String.valueOf(savedPath).concat(".metadata"), new String[0]).toAbsolutePath();
        if (savedPath.toFile().exists() && Files.exists(metaFile, new LinkOption[0])) {
            RequestMetadata localMetadata = this.fileMapperService.read(metaFile.toString(), RequestMetadata.class);
            String sha = DesktopUtil.getChecksum(savedPath.toFile(), Headers.SHA1.getValue());
            if (Objects.isNull(localMetadata) || !Objects.equals(localMetadata.getSha1(), sha)) {
                throw new IOException("sha not equals");
            }
            return savedPath;
        }
        return null;
    }

    private Path getResourceWithoutHttpHead(String url, Path metaFile, Path urlPath) throws IOException, NoSuchAlgorithmException {
        long purgeTime = System.currentTimeMillis() - (long)(this.timeToLife * 1000);
        if (urlPath.toFile().lastModified() < purgeTime) {
            Files.deleteIfExists(urlPath);
        }
        if (urlPath.toFile().exists() && Files.exists(metaFile, new LinkOption[0])) {
            RequestMetadata localMetadata = this.fileMapperService.read(metaFile.toString(), RequestMetadata.class);
            String sha = DesktopUtil.getChecksum(urlPath.toFile(), Headers.SHA1.getValue());
            if (Objects.nonNull(localMetadata) && Objects.equals(localMetadata.getSha1(), sha)) {
                log.trace("use local file -> " + url);
                return urlPath;
            }
            log.trace("not proper hashsum HTTP GET -> " + url);
            this.generateRequestMetadata(url, urlPath, metaFile);
            return urlPath;
        }
        log.trace("HTTP GET -> " + url);
        this.generateRequestMetadata(url, urlPath, metaFile);
        return urlPath;
    }

    private Path getResourceWithHttpHead(String url, Path metaFile, Path urlPath) throws IOException, NoSuchAlgorithmException {
        boolean fileExists = urlPath.toFile().exists();
        try {
            if (fileExists) {
                RequestMetadata serverMetadata = this.httpService.getMetaByUrl(url);
                RequestMetadata localMetadata = this.fileMapperService.read(metaFile.toString(), RequestMetadata.class);
                log.info("do head request -> {} {} local file {}", new Object[]{url, localMetadata, urlPath});
                if (Objects.nonNull(localMetadata) && Objects.nonNull(localMetadata.getETag()) && StringUtils.equals((CharSequence)serverMetadata.getETag(), (CharSequence)localMetadata.getETag()) && StringUtils.equals((CharSequence)serverMetadata.getLastModified(), (CharSequence)localMetadata.getLastModified()) && StringUtils.equals((CharSequence)DesktopUtil.getChecksum(urlPath.toFile(), "SHA-1"), (CharSequence)localMetadata.getSha1())) {
                    return urlPath;
                }
                return this.generateRequestMetadata(url, urlPath, metaFile);
            }
            return this.generateRequestMetadata(url, urlPath, metaFile);
        }
        catch (Exception e) {
            log.error("error with url " + url);
            throw e;
        }
    }

    private Path generateRequestMetadata(String url, Path urlPath, Path metaFile) throws IOException, NoSuchAlgorithmException {
        RequestMetadata requestMetadata = this.httpService.getRequestByUrlAndSave(url, urlPath);
        requestMetadata.setSha1(DesktopUtil.getChecksum(urlPath.toFile(), "SHA-1"));
        this.fileMapperService.write(requestMetadata, metaFile.toString());
        return urlPath;
    }

    protected Path buildPath(String url) {
        Path urlPath = Paths.get(this.directory.toString(), url.replaceAll("://", "_").replaceAll("[:?=]", "_"));
        return urlPath;
    }
}

