/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.injection;

import java.io.File;
import java.io.FileWriter;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.tlauncher.injection.Injection;
import org.tlauncher.injection.InjectionHelper;
import org.tlauncher.injection.InjectionManager;
import org.tlauncher.injection.InjectionResult;
import org.tlauncher.injection.Injections;
import org.tlauncher.tweaker.Tweaker;

public class InjectionClassTransformer
implements IClassTransformer {
    private static final String LOG_PREFIX = "[Injection] ";
    private final InjectionManager injectionManager;

    public InjectionClassTransformer() {
        HashMap<String, Boolean> isInjectionIgnoredMap = new HashMap<String, Boolean>();
        if (Tweaker.ignoredInjections != null) {
            for (String injection : Tweaker.ignoredInjections) {
                isInjectionIgnoredMap.put(injection, true);
            }
        }
        this.injectionManager = new InjectionManager(isInjectionIgnoredMap);
        this.registerInjections();
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        int i;
        byte[] sourceBytes = basicClass;
        List<Injection> injections = this.injectionManager.getInjections(transformedName);
        for (i = 0; i < injections.size(); ++i) {
            InjectionHelper helper;
            Injection injection = injections.remove(i);
            InjectionResult injectionResult = injection.process(basicClass, helper = this.injectionManager.getHelper(transformedName));
            if (injectionResult != InjectionResult.SUCCESS) {
                System.out.printf("[Injection] Injection#%s into %s failed with result: %s.\n", new Object[]{i, transformedName, injectionResult});
                return sourceBytes;
            }
            basicClass = helper.getClassBytes();
        }
        if (i > 0) {
            System.out.printf("[Injection] Injection into %s ended successfully with %s injections.\n", transformedName, i);
        }
        return basicClass;
    }

    private void registerInjections() {
        System.out.println("[Injection] Injection Class Transformer started");
        Injections injections = new Injections();
        injections.registerInjections(this.injectionManager);
    }

    protected static void printNodes(InsnList insnList) {
        ListIterator iterator = insnList.iterator();
        int i = 0;
        System.out.println();
        while (iterator.hasNext()) {
            System.out.print(i + ": ");
            System.out.println(InjectionClassTransformer.getNodePrint((AbstractInsnNode)iterator.next()));
            ++i;
        }
    }

    protected static void saveNodesPrint(InsnList insnList, File file) {
        ListIterator iterator = insnList.iterator();
        int i = 0;
        FileWriter fileWriter = new FileWriter(file);
        while (iterator.hasNext()) {
            fileWriter.append(String.valueOf(i)).append(": ").append(InjectionClassTransformer.getNodePrint((AbstractInsnNode)iterator.next())).append("\n");
            ++i;
        }
        fileWriter.flush();
        fileWriter.close();
    }

    protected static String getNodePrint(AbstractInsnNode node) {
        Object s = "";
        s = (String)s + InjectionClassTransformer.getOpcodeName(node.getOpcode()) + " ";
        s = node instanceof MethodInsnNode ? (String)s + ((MethodInsnNode)node).owner + " " + ((MethodInsnNode)node).name + " " + ((MethodInsnNode)node).desc : (node instanceof VarInsnNode ? (String)s + ((VarInsnNode)node).var : (node instanceof FieldInsnNode ? (String)s + ((FieldInsnNode)node).owner + " " + ((FieldInsnNode)node).name + " " + ((FieldInsnNode)node).desc : (String)s + node));
        return s;
    }

    protected static String getOpcodeName(int opcode) {
        return Arrays.stream(Opcodes.class.getDeclaredFields()).filter(field -> field.getType() == Integer.TYPE || field.getType() == Integer.class).filter(field -> Modifier.isPublic(field.getModifiers())).filter(field -> Modifier.isStatic(field.getModifiers())).filter(field -> {
            try {
                Integer integer = (Integer)field.get(null);
                return integer == opcode;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                return false;
            }
        }).findFirst().map(Field::getName).orElse(Integer.toString(opcode));
    }
}

