/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.renderer.texture;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.FilterMode;
import com.mojang.blaze3d.textures.GpuTexture;
import com.mojang.blaze3d.textures.TextureFormat;
import java.io.IOException;
import net.minecraft.class_1044;
import net.minecraft.class_3300;
import org.tlauncher.injection.mapping.MappingManager;
import org.tlauncher.injection.mapping.ObfClass;
import org.tlauncher.renderer.image.ImageWrap;
import org.tlauncher.renderer.image.NativeImageWrap;
import org.tlauncher.util.TLModCfg;

public class LightTexture
extends class_1044 {
    private ImageWrap imageWrap;

    public LightTexture(ImageWrap imageWrap) {
        this.imageWrap = imageWrap;
        if (TLModCfg.getMinecraftVersion().isGreaterThanOrEquals("1.21.5")) {
            GpuTexture gpuTexture;
            if (TLModCfg.getMinecraftVersion().isGreaterThanOrEquals("1.21.6")) {
                gpuTexture = RenderSystem.getDevice().createTexture(null, 5, TextureFormat.RGBA8, imageWrap.getWidth(), imageWrap.getHeight(), 1, 1);
                this.setGpuTexture(gpuTexture);
                gpuTexture.setTextureFilter(FilterMode.NEAREST, false);
                this.setGpuTextureView(RenderSystem.getDevice().createTextureView(gpuTexture));
            } else {
                gpuTexture = RenderSystem.getDevice().createTexture(null, TextureFormat.RGBA8, imageWrap.getWidth(), imageWrap.getHeight(), 1);
                this.setGpuTexture(gpuTexture);
            }
            RenderSystem.getDevice().createCommandEncoder().writeToTexture(gpuTexture, ((NativeImageWrap)imageWrap).getNativeImage());
        } else if (!RenderSystem.isOnRenderThread()) {
            RenderSystem.recordRenderCall(this::upload);
        } else {
            this.upload();
        }
    }

    private void setGpuTexture(Object texture) {
        String fieldName;
        if (TLModCfg.getMinecraftVersion().isFabric()) {
            fieldName = "field_56974";
        } else {
            ObfClass clazz = MappingManager.instance().getMappings().getClass("AbstractTexture");
            fieldName = clazz.getField("texture").getObfName();
        }
        ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField(fieldName).set((Object)this, texture);
    }

    private void setGpuTextureView(Object textureView) {
        String fieldName;
        if (TLModCfg.getMinecraftVersion().isFabric()) {
            fieldName = "field_60597";
        } else {
            ObfClass clazz = MappingManager.instance().getMappings().getClass("AbstractTexture");
            fieldName = clazz.getField("textureView").getObfName();
        }
        ((Object)((Object)this)).getClass().getSuperclass().getDeclaredField(fieldName).set((Object)this, textureView);
    }

    public void upload() {
        this.imageWrap.allocateTexture(this.method_4624());
        this.method_23207();
        this.imageWrap.uploadTexture(this.method_4624());
    }

    public void method_4625(class_3300 p_117955_) throws IOException {
    }

    public void close() {
        if (this.imageWrap != null) {
            if (TLModCfg.getMinecraftVersion().isGreaterThanOrEquals("1.21.5")) {
                this.imageWrap.close();
                this.imageWrap = null;
                super.close();
            } else {
                this.imageWrap.close();
                this.method_4528();
                this.imageWrap = null;
            }
        }
    }
}

