/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.util;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.EnumMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.StampedLock;
import me.pepperbell.continuity.client.util.RenderUtil;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableMesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadTransform;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1920;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_5819;
import net.minecraft.class_773;
import net.minecraft.class_9891;
import org.jetbrains.annotations.Unmodifiable;

public final class SpriteCalculator {
    private static final class_773 MODELS = class_310.method_1551().method_1554().method_4743();
    private static final EnumMap<class_2350, SpriteCache> SPRITE_CACHES = new EnumMap(class_2350.class);

    public static @Unmodifiable Set<class_1058> getSprites(class_2680 state, class_2350 face) {
        return SPRITE_CACHES.get(face).getSprites(state);
    }

    public static void clearCache() {
        for (SpriteCache cache : SPRITE_CACHES.values()) {
            cache.clear();
        }
    }

    static {
        for (class_2350 direction : class_2350.values()) {
            SPRITE_CACHES.put(direction, new SpriteCache(direction));
        }
    }

    private static class SpriteCache {
        private final class_2350 face;
        private final Reference2ObjectOpenHashMap<class_2680, Set<class_1058>> spritesMap = new Reference2ObjectOpenHashMap();
        private final MutableMesh mutableMesh = Renderer.get().mutableMesh();
        private final CollectingQuadTransform quadTransform;
        private final class_5819 random = class_5819.method_43053();
        private final StampedLock lock = new StampedLock();

        public SpriteCache(class_2350 face) {
            this.face = face;
            this.quadTransform = new CollectingQuadTransform(face);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public @Unmodifiable Set<class_1058> getSprites(class_2680 state) {
            Set<class_1058> sprites;
            long optimisticReadStamp = this.lock.tryOptimisticRead();
            if (optimisticReadStamp != 0L) {
                try {
                    sprites = (Set<class_1058>)this.spritesMap.get((Object)state);
                    if (sprites != null && this.lock.validate(optimisticReadStamp)) {
                        return sprites;
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            long readStamp = this.lock.readLock();
            try {
                sprites = (Set)this.spritesMap.get((Object)state);
            }
            finally {
                this.lock.unlockRead(readStamp);
            }
            if (sprites == null) {
                long writeStamp = this.lock.writeLock();
                try {
                    sprites = (Set)this.spritesMap.get((Object)state);
                    if (sprites == null) {
                        sprites = this.calculateSprites(state);
                        this.spritesMap.put((Object)state, sprites);
                    }
                }
                finally {
                    this.lock.unlockWrite(writeStamp);
                }
            }
            return sprites;
        }

        private @Unmodifiable Set<class_1058> calculateSprites(class_2680 state) {
            class_1087 model = MODELS.method_3335(state);
            QuadEmitter emitter = this.mutableMesh.emitter();
            this.quadTransform.clear();
            emitter.pushTransform((QuadTransform)this.quadTransform);
            this.random.method_43052(42L);
            try {
                model.emitQuads(emitter, (class_1920)class_9891.field_52611, class_2338.field_10980, state, this.random, cullFace -> false);
            }
            catch (Exception exception) {
                // empty catch block
            }
            emitter.popTransform();
            Set<class_1058> sprites = this.quadTransform.result();
            return !sprites.isEmpty() ? sprites : Set.of(model.method_68511());
        }

        public void clear() {
            long writeStamp = this.lock.writeLock();
            try {
                this.spritesMap.clear();
                this.quadTransform.clear();
            }
            finally {
                this.lock.unlockWrite(writeStamp);
            }
        }

        private static class CollectingQuadTransform
        implements QuadTransform {
            private final class_2350 face;
            private final List<class_1058> sprites = new ObjectArrayList();

            private CollectingQuadTransform(class_2350 face) {
                this.face = face;
            }

            public boolean transform(MutableQuadView quad) {
                if (quad.lightFace() == this.face) {
                    this.sprites.add(RenderUtil.getSpriteFinder().find((QuadView)quad));
                }
                return false;
            }

            public void clear() {
                this.sprites.clear();
            }

            public @Unmodifiable Set<class_1058> result() {
                return Set.copyOf(this.sprites);
            }
        }
    }
}

