/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render;

import com.seibel.distanthorizons.api.interfaces.override.rendering.IDhApiCullingFrustum;
import com.seibel.distanthorizons.api.objects.math.DhApiMat4f;
import com.seibel.distanthorizons.core.util.math.Mat4f;
import org.joml.FrustumIntersection;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class DhFrustumBounds
implements IDhApiCullingFrustum {
    private final FrustumIntersection frustum;
    private final Vector3f boundsMin = new Vector3f();
    private final Vector3f boundsMax = new Vector3f();
    public float worldMinY;
    public float worldMaxY;

    public DhFrustumBounds() {
        this.frustum = new FrustumIntersection();
    }

    @Override
    public void update(int worldMinBlockY, int worldMaxBlockY, DhApiMat4f dhWorldViewProjection) {
        this.worldMinY = worldMinBlockY;
        this.worldMaxY = worldMaxBlockY;
        Matrix4f worldViewProjection = new Matrix4f((Matrix4fc)Mat4f.createJomlMatrix(dhWorldViewProjection));
        this.frustum.set((Matrix4fc)worldViewProjection);
        Matrix4f matWorldViewProjectionInv = new Matrix4f((Matrix4fc)worldViewProjection).invert();
        matWorldViewProjectionInv.frustumAabb(this.boundsMin, this.boundsMax);
    }

    @Override
    public boolean intersects(int lodBlockPosMinX, int lodBlockPosMinZ, int lodBlockWidth, int lodDetailLevel) {
        Vector3f lodMin = new Vector3f((float)lodBlockPosMinX, this.worldMinY, (float)lodBlockPosMinZ);
        Vector3f lodMax = new Vector3f((float)(lodBlockPosMinX + lodBlockWidth), this.worldMaxY, (float)(lodBlockPosMinZ + lodBlockWidth));
        return this.frustum.testAab((Vector3fc)lodMin, (Vector3fc)lodMax);
    }

    @Override
    public int getPriority() {
        return -1;
    }
}

