/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.render.renderer;

import com.seibel.distanthorizons.api.interfaces.override.rendering.IDhApiFramebuffer;
import com.seibel.distanthorizons.api.interfaces.override.rendering.IDhApiShaderProgram;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiAfterColorDepthTextureCreatedEvent;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiBeforeApplyShaderRenderEvent;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiBeforeBufferRenderEvent;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiBeforeColorDepthTextureCreatedEvent;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiBeforeRenderCleanupEvent;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiBeforeRenderPassEvent;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiBeforeRenderSetupEvent;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiBeforeTextureClearEvent;
import com.seibel.distanthorizons.api.methods.events.abstractEvents.DhApiColorDepthTextureCreatedEvent;
import com.seibel.distanthorizons.api.methods.events.sharedParameterObjects.DhApiRenderParam;
import com.seibel.distanthorizons.api.methods.events.sharedParameterObjects.DhApiTextureCreatedParam;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dataObjects.render.bufferBuilding.ColumnRenderBuffer;
import com.seibel.distanthorizons.core.dependencyInjection.ModAccessorInjector;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.logging.ConfigBasedLogger;
import com.seibel.distanthorizons.core.logging.ConfigBasedSpamLogger;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos;
import com.seibel.distanthorizons.core.render.DhApiRenderProxy;
import com.seibel.distanthorizons.core.render.RenderBufferHandler;
import com.seibel.distanthorizons.core.render.glObject.GLProxy;
import com.seibel.distanthorizons.core.render.glObject.buffer.GLVertexBuffer;
import com.seibel.distanthorizons.core.render.glObject.buffer.QuadElementBuffer;
import com.seibel.distanthorizons.core.render.glObject.texture.DHDepthTexture;
import com.seibel.distanthorizons.core.render.glObject.texture.DhColorTexture;
import com.seibel.distanthorizons.core.render.glObject.texture.DhFramebuffer;
import com.seibel.distanthorizons.core.render.glObject.texture.EDhDepthBufferFormat;
import com.seibel.distanthorizons.core.render.glObject.texture.EDhInternalTextureFormat;
import com.seibel.distanthorizons.core.render.glObject.texture.EDhPixelFormat;
import com.seibel.distanthorizons.core.render.glObject.texture.EDhPixelType;
import com.seibel.distanthorizons.core.render.renderer.DebugRenderer;
import com.seibel.distanthorizons.core.render.renderer.DhTerrainShaderProgram;
import com.seibel.distanthorizons.core.render.renderer.FogRenderer;
import com.seibel.distanthorizons.core.render.renderer.SSAORenderer;
import com.seibel.distanthorizons.core.render.renderer.generic.GenericObjectRenderer;
import com.seibel.distanthorizons.core.render.renderer.shaders.DhApplyShader;
import com.seibel.distanthorizons.core.util.math.Mat4f;
import com.seibel.distanthorizons.core.util.math.Vec3d;
import com.seibel.distanthorizons.core.util.math.Vec3f;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftGLWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftRenderWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IProfilerWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.misc.ILightMapWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.modAccessor.AbstractOptifineAccessor;
import com.seibel.distanthorizons.core.wrapperInterfaces.modAccessor.IIrisAccessor;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import com.seibel.distanthorizons.coreapi.DependencyInjection.ApiEventInjector;
import com.seibel.distanthorizons.coreapi.DependencyInjection.OverrideInjector;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.lwjgl.opengl.GL32;

public class LodRenderer {
    public static final ConfigBasedLogger EVENT_LOGGER = new ConfigBasedLogger(LogManager.getLogger(LodRenderer.class), () -> Config.Common.Logging.logRendererBufferEvent.get());
    public static final ConfigBasedSpamLogger SPAM_LOGGER = new ConfigBasedSpamLogger(LogManager.getLogger(LodRenderer.class), () -> Config.Common.Logging.logRendererBufferEvent.get(), 1);
    private static final IIrisAccessor IRIS_ACCESSOR = ModAccessorInjector.INSTANCE.get(IIrisAccessor.class);
    private static final IMinecraftClientWrapper MC = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
    private static final IMinecraftRenderWrapper MC_RENDER = SingletonInjector.INSTANCE.get(IMinecraftRenderWrapper.class);
    private static final IMinecraftGLWrapper GLMC = SingletonInjector.INSTANCE.get(IMinecraftGLWrapper.class);
    public static final boolean ENABLE_DRAW_LAG_SPIKE_LOGGING = false;
    public static final long DRAW_LAG_SPIKE_THRESHOLD_NS = TimeUnit.NANOSECONDS.convert(20L, TimeUnit.MILLISECONDS);
    public static boolean transparencyEnabled = true;
    public static boolean fakeOceanFloor = true;
    private static final ReentrantLock renderLock = new ReentrantLock();
    private static int activeFramebufferId = -1;
    private static int activeColorTextureId = -1;
    private static int activeDepthTextureId = -1;
    private int cachedWidth;
    private int cachedHeight;
    private final ReentrantLock setupLock = new ReentrantLock();
    public final RenderBufferHandler bufferHandler;
    public final GenericObjectRenderer genericObjectRenderer;
    private IDhApiShaderProgram lodRenderProgram = null;
    public QuadElementBuffer quadIBO = null;
    private boolean isSetupComplete = false;
    private IDhApiFramebuffer framebuffer;
    private DhColorTexture nullableColorTexture;
    private DHDepthTexture depthTexture;
    private boolean usingMcFrameBuffer = false;
    private boolean rendererClosed = false;

    public LodRenderer(RenderBufferHandler bufferHandler, GenericObjectRenderer genericObjectRenderer) {
        this.bufferHandler = bufferHandler;
        this.genericObjectRenderer = genericObjectRenderer;
    }

    public void close() {
        if (this.rendererClosed) {
            EVENT_LOGGER.warn("close() called twice!", new Object[0]);
            return;
        }
        this.rendererClosed = true;
        renderLock.lock();
        try {
            EVENT_LOGGER.info("Shutting down " + LodRenderer.class.getSimpleName() + "...", new Object[0]);
            this.cleanup();
            this.bufferHandler.close();
            EVENT_LOGGER.info("Finished shutting down " + LodRenderer.class.getSimpleName(), new Object[0]);
        }
        finally {
            renderLock.unlock();
        }
    }

    public void drawLods(IClientLevelWrapper clientLevelWrapper, DhApiRenderParam renderEventParam, IProfilerWrapper profiler) {
        this.renderLodPass(clientLevelWrapper, renderEventParam, profiler, false);
    }

    public void drawDeferredLods(IClientLevelWrapper clientLevelWrapper, DhApiRenderParam renderEventParam, IProfilerWrapper profiler) {
        this.renderLodPass(clientLevelWrapper, renderEventParam, profiler, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderLodPass(IClientLevelWrapper clientLevelWrapper, DhApiRenderParam renderEventParam, IProfilerWrapper profiler, boolean runningDeferredPass) {
        boolean renderingFirstPass;
        boolean deferTransparentRendering = DhApiRenderProxy.INSTANCE.getDeferTransparentRendering();
        if (runningDeferredPass && !deferTransparentRendering) {
            return;
        }
        boolean bl = renderingFirstPass = !runningDeferredPass;
        if (this.rendererClosed) {
            EVENT_LOGGER.error("LOD rendering attempted after the renderer has been shut down!", new Object[0]);
            return;
        }
        if (AbstractOptifineAccessor.optifinePresent() && MC_RENDER.getTargetFrameBuffer() == -1) {
            return;
        }
        if (!renderLock.tryLock()) {
            return;
        }
        try {
            ILightMapWrapper lightmap = MC_RENDER.getLightmapWrapper(clientLevelWrapper);
            if (lightmap == null) {
                return;
            }
            ApiEventInjector.INSTANCE.fireAllEvents(DhApiBeforeRenderSetupEvent.class, renderEventParam);
            this.setupGLStateAndRenderObjects(profiler, renderEventParam, renderingFirstPass);
            if (!this.isSetupComplete) {
                return;
            }
            lightmap.bind();
            this.quadIBO.bind();
            if (renderingFirstPass) {
                this.bufferHandler.buildRenderListAndUpdateSections(clientLevelWrapper, renderEventParam, MC_RENDER.getLookAtVector());
                transparencyEnabled = Config.Client.Advanced.Graphics.Quality.transparency.get().transparencyEnabled;
                fakeOceanFloor = Config.Client.Advanced.Graphics.Quality.transparency.get().fakeTransparencyEnabled;
            }
            if (!runningDeferredPass) {
                boolean cancelApplyShader;
                Mat4f combinedMatrix;
                GLMC.disableBlend();
                profiler.popPush("LOD Opaque");
                ApiEventInjector.INSTANCE.fireAllEvents(DhApiBeforeRenderPassEvent.class, renderEventParam);
                this.bufferHandler.renderOpaque(this, renderEventParam);
                if (Config.Client.Advanced.Graphics.GenericRendering.enableGenericRendering.get().booleanValue()) {
                    profiler.popPush("Custom Objects");
                    this.genericObjectRenderer.render(renderEventParam, profiler, true);
                }
                if (Config.Client.Advanced.Graphics.Ssao.enableSsao.get().booleanValue()) {
                    profiler.popPush("LOD SSAO");
                    SSAORenderer.INSTANCE.render(new Mat4f(renderEventParam.dhProjectionMatrix), renderEventParam.partialTicks);
                }
                if (Config.Client.Advanced.Graphics.GenericRendering.enableGenericRendering.get().booleanValue()) {
                    profiler.popPush("Custom Objects");
                    this.genericObjectRenderer.render(renderEventParam, profiler, false);
                }
                if (!deferTransparentRendering && Config.Client.Advanced.Graphics.Quality.transparency.get().transparencyEnabled) {
                    this.renderTransparentBuffersAndFireApiEvent(profiler, renderEventParam);
                }
                if (Config.Client.Advanced.Graphics.Fog.enableDhFog.get().booleanValue()) {
                    profiler.popPush("LOD Fog");
                    combinedMatrix = new Mat4f(renderEventParam.dhProjectionMatrix);
                    combinedMatrix.multiply(renderEventParam.dhModelViewMatrix);
                    FogRenderer.INSTANCE.render(combinedMatrix, renderEventParam.partialTicks);
                }
                if (Config.Client.Advanced.Debugging.DebugWireframe.enableRendering.get().booleanValue()) {
                    profiler.popPush("Debug wireframes");
                    combinedMatrix = new Mat4f(renderEventParam.dhProjectionMatrix);
                    combinedMatrix.multiply(renderEventParam.dhModelViewMatrix);
                    DebugRenderer.INSTANCE.render(combinedMatrix);
                }
                profiler.popPush("LOD cleanup");
                if (this.usingMcFrameBuffer) {
                    GL32.glClear((int)256);
                }
                if (!(cancelApplyShader = ApiEventInjector.INSTANCE.fireAllEvents(DhApiBeforeApplyShaderRenderEvent.class, renderEventParam))) {
                    profiler.popPush("LOD Apply");
                    DhApplyShader.INSTANCE.render(renderEventParam.partialTicks);
                }
            } else if (Config.Client.Advanced.Graphics.Quality.transparency.get().transparencyEnabled) {
                profiler.popPush("LOD Transparent");
                this.renderTransparentBuffersAndFireApiEvent(profiler, renderEventParam);
                if (Config.Client.Advanced.Graphics.Fog.enableDhFog.get().booleanValue()) {
                    profiler.popPush("LOD Fog");
                    Mat4f combinedMatrix = new Mat4f(renderEventParam.dhProjectionMatrix);
                    combinedMatrix.multiply(renderEventParam.dhModelViewMatrix);
                    FogRenderer.INSTANCE.render(combinedMatrix, renderEventParam.partialTicks);
                }
            }
            profiler.popPush("LOD cleanup");
            ApiEventInjector.INSTANCE.fireAllEvents(DhApiBeforeRenderCleanupEvent.class, renderEventParam);
            lightmap.unbind();
            this.quadIBO.unbind();
            IDhApiShaderProgram shaderProgram = this.lodRenderProgram;
            IDhApiShaderProgram shaderProgramOverride = OverrideInjector.INSTANCE.get(IDhApiShaderProgram.class);
            if (shaderProgramOverride != null && shaderProgram.overrideThisFrame()) {
                shaderProgram = shaderProgramOverride;
            }
            shaderProgram.unbind();
            profiler.pop();
            SPAM_LOGGER.incLogTries();
        }
        finally {
            renderLock.unlock();
        }
    }

    private void renderTransparentBuffersAndFireApiEvent(IProfilerWrapper profiler, DhApiRenderParam renderEventParam) {
        profiler.popPush("LOD Transparent");
        GLMC.enableBlend();
        GLMC.enableDepthTest();
        GL32.glBlendEquation((int)32774);
        GLMC.glBlendFuncSeparate(770, 771, 1, 771);
        ApiEventInjector.INSTANCE.fireAllEvents(DhApiBeforeRenderPassEvent.class, renderEventParam);
        this.bufferHandler.renderTransparent(this, renderEventParam);
    }

    public void setModelViewMatrixOffset(DhBlockPos pos, DhApiRenderParam renderEventParam) throws IllegalStateException {
        Vec3d cam = MC_RENDER.getCameraExactPosition();
        Vec3f modelPos = new Vec3f((float)((double)pos.getX() - cam.x), (float)((double)pos.getY() - cam.y), (float)((double)pos.getZ() - cam.z));
        IDhApiShaderProgram shaderProgram = this.lodRenderProgram;
        IDhApiShaderProgram shaderProgramOverride = OverrideInjector.INSTANCE.get(IDhApiShaderProgram.class);
        if (shaderProgramOverride != null && shaderProgram.overrideThisFrame()) {
            shaderProgram = shaderProgramOverride;
        }
        shaderProgram.bind();
        shaderProgram.setModelOffsetPos(modelPos);
        ApiEventInjector.INSTANCE.fireAllEvents(DhApiBeforeBufferRenderEvent.class, new DhApiBeforeBufferRenderEvent.EventParam(renderEventParam, modelPos));
    }

    public void drawVbo(GLVertexBuffer vbo, ColumnRenderBuffer parentBufferContainer) {
        if (Config.Client.Advanced.Debugging.OpenGl.validateBufferIdsBeforeRendering.get().booleanValue() && !GL32.glIsBuffer((int)vbo.getId())) {
            if (SPAM_LOGGER.canMaybeLog()) {
                SPAM_LOGGER.warn("Attempted to draw invalid buffer: [" + vbo.getId() + "], expected size: [" + vbo.getSize() + "], upload complete: [" + parentBufferContainer.buffersUploaded + "], upload in progress: [" + parentBufferContainer.uploadInProgress() + "], buffer blockPos: [" + parentBufferContainer.blockPos + "].", new Object[0]);
            }
            return;
        }
        IDhApiShaderProgram shaderProgram = this.lodRenderProgram;
        IDhApiShaderProgram shaderProgramOverride = OverrideInjector.INSTANCE.get(IDhApiShaderProgram.class);
        if (shaderProgramOverride != null && shaderProgram.overrideThisFrame()) {
            shaderProgram = shaderProgramOverride;
        }
        vbo.bind();
        shaderProgram.bindVertexBuffer(vbo.getId());
        GL32.glDrawElements((int)4, (int)(vbo.getVertexCount() / 4 * 6), (int)this.quadIBO.getType(), (long)0L);
        vbo.unbind();
    }

    private void setupGLStateAndRenderObjects(IProfilerWrapper profiler, DhApiRenderParam renderEventParam, boolean firstPass) {
        boolean clearTextures;
        int mcColorTextureId;
        profiler.push("LOD draw setup");
        if (!this.isSetupComplete) {
            this.setupRenderObjects();
            if (!this.isSetupComplete) {
                return;
            }
        }
        if (MC_RENDER.getTargetFrameBufferViewportWidth() != this.cachedWidth || MC_RENDER.getTargetFrameBufferViewportHeight() != this.cachedHeight) {
            this.createColorAndDepthTextures();
        }
        IDhApiFramebuffer activeFrameBuffer = this.framebuffer;
        IDhApiFramebuffer framebufferOverride = OverrideInjector.INSTANCE.get(IDhApiFramebuffer.class);
        if (framebufferOverride != null && framebufferOverride.overrideThisFrame()) {
            activeFrameBuffer = framebufferOverride;
        }
        activeFramebufferId = activeFrameBuffer.getId();
        activeDepthTextureId = this.depthTexture.getTextureId();
        activeColorTextureId = this.nullableColorTexture != null ? this.nullableColorTexture.getTextureId() : (mcColorTextureId = GL32.glGetFramebufferAttachmentParameteri((int)36160, (int)36064, (int)36049));
        activeFrameBuffer.bind();
        GL32.glPolygonMode((int)1032, (int)6914);
        GLMC.enableFaceCulling();
        GLMC.glBlendFunc(770, 771);
        GLMC.glBlendFuncSeparate(770, 771, 1, 0);
        GL32.glDisable((int)3089);
        GLMC.enableDepthTest();
        GLMC.glDepthFunc(513);
        GLMC.enableDepthMask();
        GL32.glViewport((int)0, (int)0, (int)this.cachedWidth, (int)this.cachedHeight);
        if (!this.isSetupComplete) {
            this.setupRenderObjects();
        } else {
            this.lodRenderProgram.bind();
        }
        IDhApiShaderProgram shaderProgramOverride = OverrideInjector.INSTANCE.get(IDhApiShaderProgram.class);
        if (shaderProgramOverride != null) {
            shaderProgramOverride.fillUniformData(renderEventParam);
        }
        this.lodRenderProgram.fillUniformData(renderEventParam);
        boolean bl = clearTextures = !ApiEventInjector.INSTANCE.fireAllEvents(DhApiBeforeTextureClearEvent.class, renderEventParam);
        if (clearTextures) {
            GL32.glClearDepth((double)1.0);
            float[] clearColorValues = new float[4];
            GL32.glGetFloatv((int)3106, (float[])clearColorValues);
            GL32.glClearColor((float)clearColorValues[0], (float)clearColorValues[1], (float)clearColorValues[2], (float)1.0f);
            if (this.usingMcFrameBuffer && framebufferOverride == null) {
                activeFrameBuffer.addDepthAttachment(this.depthTexture.getTextureId(), EDhDepthBufferFormat.DEPTH32F.isCombinedStencil());
                GL32.glClear((int)256);
            } else if (firstPass) {
                GL32.glClear((int)16640);
            }
        }
    }

    private void setupRenderObjects() {
        if (this.isSetupComplete) {
            EVENT_LOGGER.warn("Renderer setup called but it has already completed setup!", new Object[0]);
            return;
        }
        if (!GLProxy.hasInstance()) {
            EVENT_LOGGER.warn("Renderer setup called but GLProxy has not yet been setup!", new Object[0]);
            return;
        }
        try {
            this.setupLock.lock();
            EVENT_LOGGER.info("Setting up renderer", new Object[0]);
            this.lodRenderProgram = new DhTerrainShaderProgram();
            this.quadIBO = new QuadElementBuffer();
            this.quadIBO.reserve(ColumnRenderBuffer.MAX_QUADS_PER_BUFFER);
            if (AbstractOptifineAccessor.optifinePresent()) {
                int currentFrameBufferId = MC_RENDER.getTargetFrameBuffer();
                this.framebuffer = new DhFramebuffer(currentFrameBufferId);
                this.usingMcFrameBuffer = true;
            } else {
                this.framebuffer = new DhFramebuffer();
                this.usingMcFrameBuffer = false;
            }
            this.createColorAndDepthTextures();
            if (this.framebuffer.getStatus() != 36053) {
                EVENT_LOGGER.warn("FrameBuffer [" + this.framebuffer.getId() + "] isn't complete.", new Object[0]);
                return;
            }
            this.isSetupComplete = true;
            EVENT_LOGGER.info("Renderer setup complete", new Object[0]);
        }
        finally {
            this.setupLock.unlock();
        }
    }

    private void createColorAndDepthTextures() {
        int oldWidth = this.cachedWidth;
        int oldHeight = this.cachedHeight;
        this.cachedWidth = MC_RENDER.getTargetFrameBufferViewportWidth();
        this.cachedHeight = MC_RENDER.getTargetFrameBufferViewportHeight();
        DhApiTextureCreatedParam textureCreatedParam = new DhApiTextureCreatedParam(oldWidth, oldHeight, this.cachedWidth, this.cachedHeight);
        ApiEventInjector.INSTANCE.fireAllEvents(DhApiColorDepthTextureCreatedEvent.class, new DhApiColorDepthTextureCreatedEvent.EventParam(textureCreatedParam));
        ApiEventInjector.INSTANCE.fireAllEvents(DhApiBeforeColorDepthTextureCreatedEvent.class, textureCreatedParam);
        IDhApiFramebuffer framebufferOverride = OverrideInjector.INSTANCE.get(IDhApiFramebuffer.class);
        this.depthTexture = new DHDepthTexture(this.cachedWidth, this.cachedHeight, EDhDepthBufferFormat.DEPTH32F);
        this.framebuffer.addDepthAttachment(this.depthTexture.getTextureId(), EDhDepthBufferFormat.DEPTH32F.isCombinedStencil());
        if (framebufferOverride != null) {
            framebufferOverride.addDepthAttachment(this.depthTexture.getTextureId(), EDhDepthBufferFormat.DEPTH32F.isCombinedStencil());
        }
        if (!this.usingMcFrameBuffer) {
            this.nullableColorTexture = DhColorTexture.builder().setDimensions(this.cachedWidth, this.cachedHeight).setInternalFormat(EDhInternalTextureFormat.RGBA8).setPixelType(EDhPixelType.UNSIGNED_BYTE).setPixelFormat(EDhPixelFormat.RGBA).build();
            this.framebuffer.addColorAttachment(0, this.nullableColorTexture.getTextureId());
            if (framebufferOverride != null) {
                framebufferOverride.addColorAttachment(0, this.nullableColorTexture.getTextureId());
            }
        } else {
            this.nullableColorTexture = null;
        }
        ApiEventInjector.INSTANCE.fireAllEvents(DhApiAfterColorDepthTextureCreatedEvent.class, textureCreatedParam);
    }

    public static int getActiveFramebufferId() {
        return activeFramebufferId;
    }

    public static int getActiveColorTextureId() {
        return activeColorTextureId;
    }

    public static int getActiveDepthTextureId() {
        return activeDepthTextureId;
    }

    private void cleanup() {
        if (!GLProxy.hasInstance()) {
            EVENT_LOGGER.warn("Renderer Cleanup called but the GLProxy has never been initialized!", new Object[0]);
            return;
        }
        try {
            this.setupLock.lock();
            EVENT_LOGGER.info("Queuing Renderer Cleanup for main render thread", new Object[0]);
            GLProxy.getInstance().queueRunningOnRenderThread(() -> {
                EVENT_LOGGER.info("Renderer Cleanup Started", new Object[0]);
                if (this.lodRenderProgram != null) {
                    this.lodRenderProgram.free();
                    this.lodRenderProgram = null;
                }
                if (this.quadIBO != null) {
                    this.quadIBO.destroyAsync();
                }
                if (this.framebuffer != null && !this.usingMcFrameBuffer) {
                    this.framebuffer.destroy();
                }
                if (this.nullableColorTexture != null) {
                    this.nullableColorTexture.destroy();
                }
                if (this.depthTexture != null) {
                    this.depthTexture.destroy();
                }
                activeFramebufferId = -1;
                activeColorTextureId = -1;
                activeDepthTextureId = -1;
                EVENT_LOGGER.info("Renderer Cleanup Complete", new Object[0]);
            });
        }
        catch (Exception e) {
            this.setupLock.unlock();
        }
    }

    public static class LagSpikeCatcher {
        long timer = System.nanoTime();

        public void end(String source) {
        }
    }
}

