/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.impl.config;

import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2960;
import snownee.jade.Jade;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.impl.WailaClientRegistration;
import snownee.jade.impl.config.ServerPluginConfig;
import snownee.jade.impl.config.entry.ConfigEntry;

public class ClientPluginConfig
implements IPluginConfig {
    public static final Codec<ClientPluginConfig> CODEC = ServerPluginConfig.DATA_CODEC.xmap(ClientPluginConfig::new, IPluginConfig::values);
    private final Map<class_2960, Object> values;
    private final Map<class_2960, Object> mergedValues = Maps.newHashMap();

    private ClientPluginConfig(Map<class_2960, Object> values) {
        this.values = values;
        this.mergedValues.putAll(values);
    }

    @Override
    public boolean get(class_2960 key) {
        return (Boolean)Objects.requireNonNull(this.mergedValues.get(key));
    }

    @Override
    public <T extends Enum<T>> T getEnum(class_2960 key) {
        return (T)((Enum)Objects.requireNonNull(this.mergedValues.get(key)));
    }

    @Override
    public int getInt(class_2960 key) {
        return ((Number)this.mergedValues.get(key)).intValue();
    }

    @Override
    public float getFloat(class_2960 key) {
        return ((Number)this.mergedValues.get(key)).floatValue();
    }

    @Override
    public String getString(class_2960 key) {
        return (String)Objects.requireNonNull(this.mergedValues.get(key));
    }

    @Override
    public boolean set(class_2960 key, Object value) {
        Objects.requireNonNull(value);
        ConfigEntry<?> entry = WailaClientRegistration.instance().getConfigEntry(key);
        if (entry == null) {
            Jade.LOGGER.warn("Skip setting value for unknown option: {}, {}", (Object)key, value);
            return false;
        }
        try {
            value = entry.convertValue(value);
        }
        catch (Exception e) {
            Jade.LOGGER.warn("Skip setting illegal value for option: {}, {}", (Object)key, value);
            return false;
        }
        if (!entry.isValidValue(value)) {
            Jade.LOGGER.warn("Skip setting illegal value for option: {}, {}", (Object)key, value);
            return false;
        }
        Object old = this.values.put(key, value);
        if (!Objects.equals(old, value)) {
            this.ensureEntry(entry);
        }
        return true;
    }

    @Override
    public Map<class_2960, Object> values() {
        return this.values;
    }

    public void ensureEntry(ConfigEntry<?> entry) {
        Object old;
        class_2960 key = entry.id();
        Object value = this.values.get(key);
        if (value == null) {
            value = entry.defaultValue();
            this.values.put(key, value);
        } else {
            try {
                value = entry.convertValue(value);
                this.values.put(key, value);
            }
            catch (Exception e) {
                value = entry.defaultValue();
                this.values.put(key, value);
            }
        }
        if (entry.isSynced()) {
            value = entry.syncedValue();
        }
        if (!Objects.equals(old = this.mergedValues.put(key, value), value)) {
            entry.notifyChange();
        }
    }
}

