/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.doabarrelroll.net;

import nl.enjarai.doabarrelroll.DoABarrelRoll;
import nl.enjarai.doabarrelroll.config.ModConfigServer;
import nl.enjarai.doabarrelroll.net.packet.ConfigUpdateAckS2CPacket;
import nl.enjarai.doabarrelroll.net.packet.ConfigUpdateC2SPacket;
import nl.enjarai.doabarrelroll.util.ToastUtil;

public class ServerConfigUpdateClient<P extends ConfigUpdateC2SPacket> {
    private final PacketConstructor<P> packetConstructor;
    private boolean waitingForAck = false;

    public ServerConfigUpdateClient(PacketConstructor<P> packetConstructor) {
        this.packetConstructor = packetConstructor;
    }

    public P prepUpdatePacket(ModConfigServer config) {
        this.waitingForAck = true;
        return this.packetConstructor.construct(4, config);
    }

    public void updateAcknowledged(ConfigUpdateAckS2CPacket packet) {
        if (this.waitingForAck) {
            boolean success;
            this.waitingForAck = false;
            int protocolVersion = packet.protocolVersion();
            if (protocolVersion != 4) {
                DoABarrelRoll.LOGGER.warn("Received config update ack with unknown protocol version: {}, will attempt to read anyway", (Object)protocolVersion);
            }
            if (success = packet.success()) {
                ToastUtil.toasty("server_config_updated");
            } else {
                ToastUtil.toasty("server_config_update_failed");
            }
        }
    }

    public static interface PacketConstructor<P extends ConfigUpdateC2SPacket> {
        public P construct(int var1, ModConfigServer var2);
    }
}

