/*
 * Decompiled with CFR 0.152.
 */
package by.gdev.utils.service;

import by.gdev.util.excepiton.NotAllowWriteFileOperation;
import com.google.gson.Gson;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileMapperService {
    private static final Logger log = LoggerFactory.getLogger(FileMapperService.class);
    private Gson gson;
    private Charset charset;
    private String workingDirectory;

    public FileMapperService(Gson gson, Charset charset, String workingDirectory) {
        this.gson = gson;
        this.charset = charset;
        this.workingDirectory = workingDirectory;
    }

    public void write(Object create, String config) throws IOException, UnsupportedOperationException {
        Path path = Paths.get(this.workingDirectory, config);
        if (Files.notExists(path.getParent(), new LinkOption[0])) {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        if (Files.exists(path, new LinkOption[0]) && !path.toFile().canWrite()) {
            throw new NotAllowWriteFileOperation(path.toString());
        }
        try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(path.toFile()), this.charset);){
            this.gson.toJson(create, (Appendable)out);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T read(String file, Class<T> cl) {
        try (InputStreamReader read = new InputStreamReader((InputStream)new FileInputStream(Paths.get(this.workingDirectory, file).toFile()), this.charset);){
            Object object = this.gson.fromJson((Reader)read, cl);
            return (T)object;
        }
        catch (FileNotFoundException e) {
            log.info("file not exist " + file);
            return null;
        }
        catch (Throwable t) {
            log.warn("error read json " + file, t);
        }
        return null;
    }
}

