/*
 * Decompiled with CFR 0.152.
 */
package org.tlauncher.injection.mapping;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import org.tlauncher.injection.mapping.Mappings;
import org.tlauncher.util.TLModCfg;

public class MappingManager {
    private static final MappingManager instance = MappingManager.loadMappings();
    private final Map<String, Mappings> versions = new HashMap<String, Mappings>();

    public Mappings getMappings() {
        return this.versions.get(TLModCfg.getMinecraftVersion().getVersion());
    }

    private static MappingManager loadMappings() {
        InputStream inputStream;
        StringBuilder json = new StringBuilder();
        int i = 0;
        while ((inputStream = MappingManager.class.getResourceAsStream("mappings" + i)) != null) {
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));){
                String line;
                while ((line = bufferedReader.readLine()) != null) {
                    json.append(line);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ++i;
        }
        Gson gson = new GsonBuilder().create();
        return (MappingManager)gson.fromJson(new String(Base64.getDecoder().decode(json.toString())), MappingManager.class);
    }

    public static MappingManager instance() {
        return instance;
    }

    protected Map<String, Mappings> getVersions() {
        return this.versions;
    }
}

