/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.impl.client;

import java.util.List;
import me.pepperbell.continuity.api.client.ProcessingDataKey;
import me.pepperbell.continuity.api.client.ProcessingDataKeyRegistry;
import me.pepperbell.continuity.api.client.QuadProcessor;
import me.pepperbell.continuity.impl.client.ProcessingDataKeyRegistryImpl;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableMesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import org.jetbrains.annotations.Nullable;

public class ProcessingContextImpl
implements QuadProcessor.ProcessingContext {
    protected final MutableMesh mutableMesh = Renderer.get().mutableMesh();
    protected final Object[] processingData = new Object[ProcessingDataKeyRegistry.get().getRegisteredAmount()];

    @Override
    public QuadEmitter getExtraQuadEmitter() {
        return this.mutableMesh.emitter();
    }

    @Override
    public <T> T getData(ProcessingDataKey<T> key) {
        int index = key.getRawId();
        Object data = this.processingData[index];
        if (data == null) {
            this.processingData[index] = data = key.getValueSupplier().get();
        }
        return (T)data;
    }

    @Nullable
    public <T> T getDataOrNull(ProcessingDataKey<T> key) {
        return (T)this.processingData[key.getRawId()];
    }

    public void outputTo(QuadEmitter emitter) {
        this.mutableMesh.outputTo(emitter);
    }

    public void reset() {
        this.mutableMesh.clear();
        this.resetData();
    }

    protected void resetData() {
        List<ProcessingDataKey<?>> allResettable = ProcessingDataKeyRegistryImpl.INSTANCE.getAllResettable();
        int amount = allResettable.size();
        for (int i = 0; i < amount; ++i) {
            this.resetData(allResettable.get(i));
        }
    }

    protected <T> void resetData(ProcessingDataKey<T> key) {
        T value = this.getDataOrNull(key);
        if (value != null) {
            key.getValueResetAction().accept(value);
        }
    }
}

