/*
 * Decompiled with CFR 0.152.
 */
package org.anti_ad.mc.ipnext.integration;

import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.internal.LinkedHashMapSerializer;
import kotlinx.serialization.internal.StringSerializer;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JvmStreamsKt;
import org.anti_ad.mc.ipnext.integration.MiscKt;
import org.anti_ad.mc.ipnext.integration.SlotIntegrationData;
import org.jetbrains.annotations.NotNull;

@SourceDebugExtension(value={"SMAP\nSlotIntegrationHints.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SlotIntegrationHints.kt\norg/anti_ad/mc/ipnext/integration/SlotIntegrationHints\n+ 2 JvmStreams.kt\nkotlinx/serialization/json/JvmStreamsKt\n+ 3 common.kt\norg/anti_ad/mc/common/extensions/CommonKt\n*L\n1#1,79:1\n80#2:80\n33#3:81\n89#3,4:82\n34#3:86\n*S KotlinDebug\n*F\n+ 1 SlotIntegrationHints.kt\norg/anti_ad/mc/ipnext/integration/SlotIntegrationHints\n*L\n73#1:80\n74#1:81\n74#1:82,4\n74#1:86\n*E\n"})
public final class SlotIntegrationHints {
    @NotNull
    public static final SlotIntegrationHints INSTANCE = new SlotIntegrationHints();
    @NotNull
    private static final SlotIntegrationData DEFAULT_ENABLE = new SlotIntegrationData(false);
    @NotNull
    private static final String exampleFileName = "exampleIntegrationHints.json";
    @NotNull
    private static final String builtInHintsResource = "assets/inventoryprofilesnext/config/SlotIntegrationHints.json";
    private static Path externalHintsPath;
    private static Path configRoot;
    @NotNull
    private static Map hints;

    private SlotIntegrationHints() {
    }

    @JvmStatic
    private static /* synthetic */ void getDEFAULT_ENABLE$annotations() {
    }

    @NotNull
    public final SlotIntegrationData hintFor(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"");
        SlotIntegrationData slotIntegrationData = (SlotIntegrationData)hints.get(string);
        if (slotIntegrationData == null) {
            slotIntegrationData = DEFAULT_ENABLE;
        }
        return slotIntegrationData;
    }

    public final void init(@NotNull Path path, @NotNull Path path2, boolean bl) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"");
        this.reset();
        configRoot = path;
        externalHintsPath = path2;
        this.doInit(bl);
    }

    private final void reset() {
        hints.clear();
    }

    private final void doInit(boolean bl) {
        InputStream inputStream = SlotIntegrationHints.class.getClassLoader().getResourceAsStream(builtInHintsResource);
        if (inputStream != null) {
            Closeable closeable = inputStream;
            Throwable throwable = null;
            try {
                InputStream inputStream2 = (InputStream)closeable;
                INSTANCE.readConfig(inputStream2, bl);
            }
            catch (Throwable throwable2) {
                try {
                    Throwable throwable3 = throwable2;
                    throwable = throwable2;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                    throw throwable4;
                }
            }
            CloseableKt.closeFinally((Closeable)closeable, null);
            return;
        }
    }

    private final void readConfig(InputStream object, boolean bl) {
        Json json = MiscKt.getJson();
        json.getSerializersModule();
        Object object2 = JvmStreamsKt.decodeFromStream((Json)json, (DeserializationStrategy)((DeserializationStrategy)new LinkedHashMapSerializer((KSerializer)StringSerializer.INSTANCE, SlotIntegrationData.Companion.serializer())), (InputStream)object);
        Map cfr_ignored_0 = (Map)object2;
        try {
            ((InputStream)object).close();
        }
        catch (Throwable throwable) {}
        object = (Map)object2;
        hints.putAll(object);
    }

    static {
        hints = new LinkedHashMap();
    }
}

