/*
 * Decompiled with CFR 0.152.
 */
package xaero.map.region.texture;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTexture;
import net.minecraft.class_10366;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import xaero.map.exception.OpenGLException;
import xaero.map.graphics.CustomRenderTypes;
import xaero.map.graphics.ImprovedFramebuffer;
import xaero.map.graphics.MapRenderHelper;
import xaero.map.graphics.TextureUtils;
import xaero.map.graphics.renderer.multitexture.MultiTextureRenderTypeRenderer;
import xaero.map.graphics.renderer.multitexture.MultiTextureRenderTypeRendererProvider;
import xaero.map.misc.Misc;

public class BranchTextureRenderer {
    private ImprovedFramebuffer renderFBO;
    private GpuTexture glEmptyTexture;
    private class_4587 matrixStack = new class_4587();
    private Matrix4f projectionMatrix = new Matrix4f().setOrtho(0.0f, 64.0f, 64.0f, 0.0f, -1.0f, 1.0f);
    private MultiTextureRenderTypeRendererProvider rendererProvider = new MultiTextureRenderTypeRendererProvider(1);

    public GpuTexture getEmptyTexture() {
        this.ensureRenderTarget();
        return this.glEmptyTexture;
    }

    private void ensureRenderTarget() {
        if (this.renderFBO == null) {
            this.renderFBO = new ImprovedFramebuffer(64, 64, false);
            this.glEmptyTexture = this.renderFBO.method_30277();
            TextureUtils.clearRenderTarget((class_276)this.renderFBO, -16777216);
        }
    }

    public void render(GpuTexture destTexture, GpuTexture srcTextureTopLeft, GpuTexture srcTextureTopRight, GpuTexture srcTextureBottomLeft, GpuTexture srcTextureBottomRight, class_276 defaultFramebuffer, boolean justAllocated) {
        this.ensureRenderTarget();
        this.renderFBO.bindAsMainTarget(true);
        this.renderFBO.setColorTexture(destTexture);
        OpenGLException.checkGLError();
        Matrix4fStack shaderMatrixStack = RenderSystem.getModelViewStack();
        shaderMatrixStack.pushMatrix();
        shaderMatrixStack.identity();
        RenderSystem.setProjectionMatrix((Matrix4f)this.projectionMatrix, (class_10366)class_10366.field_54954);
        if (justAllocated) {
            TextureUtils.clearRenderTarget((class_276)this.renderFBO, -16777216);
        }
        MultiTextureRenderTypeRenderer renderer = this.rendererProvider.getRenderer(MultiTextureRenderTypeRendererProvider::defaultTextureBind, CustomRenderTypes.MAP_BRANCH);
        if (srcTextureTopLeft != null) {
            this.renderCorner(srcTextureTopLeft, 0, 0, renderer);
        }
        if (srcTextureTopRight != null) {
            this.renderCorner(srcTextureTopRight, 1, 0, renderer);
        }
        if (srcTextureBottomLeft != null) {
            this.renderCorner(srcTextureBottomLeft, 0, 1, renderer);
        }
        if (srcTextureBottomRight != null) {
            this.renderCorner(srcTextureBottomRight, 1, 1, renderer);
        }
        this.rendererProvider.draw(renderer);
        OpenGLException.checkGLError(false, "updating a map branch texture");
        shaderMatrixStack.popMatrix();
        class_310 mc = class_310.method_1551();
        Misc.minecraftOrtho(mc, false);
        this.renderFBO.bindDefaultFramebuffer(mc);
        OpenGLException.checkGLError();
    }

    private boolean renderCorner(GpuTexture srcTexture, int cornerX, int cornerY, MultiTextureRenderTypeRenderer renderer) {
        int xOffset = cornerX * 32;
        int yOffset = (1 - cornerY) * 32;
        MapRenderHelper.renderBranchUpdate(srcTexture, xOffset, yOffset, 32.0f, 32.0f, 0, 64, 64.0f, -64.0f, 64.0f, 64.0f, renderer);
        return false;
    }

    public GpuTexture getGlEmptyTexture() {
        return this.glEmptyTexture;
    }
}

