/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.blocks.behavior;

import com.mojang.serialization.Codec;
import com.unlikepaladin.pfm.blocks.BasicBathtubBlock;
import com.unlikepaladin.pfm.registry.Statistics;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2480;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3489;
import net.minecraft.class_5328;
import net.minecraft.class_6880;
import net.minecraft.class_9307;
import net.minecraft.class_9334;

public interface BathtubBehavior {
    public static final BathtubBehavior FILL_TUB_WITH_WATER = (state, world, pos, player, hand, stack) -> BathtubBehavior.fillTub(world, pos, player, hand, stack, state, class_3417.field_14834, true);
    public static final Map<class_1792, BathtubBehavior> TUB_BEHAVIOR = BathtubBehavior.createMap();
    public static final Codec<Map<class_1792, BathtubBehavior>> CODEC = Codec.unit(TUB_BEHAVIOR);
    public static final BathtubBehavior CLEAN_SHULKER_BOX = (state, world, pos, player, hand, stack) -> {
        if ((Integer)state.method_11654((class_2769)BasicBathtubBlock.LEVEL_8) == 0) {
            return class_1269.field_52423;
        }
        class_2248 block = class_2248.method_9503((class_1792)stack.method_7909());
        if (!(block instanceof class_2480)) {
            return class_1269.field_52423;
        }
        if (!world.field_9236) {
            player.method_6122(hand, stack.method_56701((class_1935)class_2246.field_10603, 1));
            player.method_7281(class_3468.field_15398);
            BasicBathtubBlock.decrementFluidLevel(state, world, pos);
        }
        return class_1269.field_5812;
    };
    public static final BathtubBehavior CLEAN_DYEABLE_ITEM = (state, world, pos, player, hand, stack) -> {
        if ((Integer)state.method_11654((class_2769)BasicBathtubBlock.LEVEL_8) == 0) {
            return class_1269.field_52423;
        }
        if (!stack.method_31573(class_3489.field_48803)) {
            return class_1269.field_52423;
        }
        if (stack.method_58694(class_9334.field_49644) == null) {
            return class_1269.field_52423;
        }
        if (!world.field_9236) {
            stack.method_57381(class_9334.field_49644);
            player.method_7281(class_3468.field_15382);
            BasicBathtubBlock.decrementFluidLevel(state, world, pos);
        }
        return class_1269.field_5812;
    };
    public static final BathtubBehavior CLEAN_BANNER = (state, world, pos, player, hand, stack) -> {
        class_9307 bannerPatternsComponent = (class_9307)stack.method_58695(class_9334.field_49619, (Object)class_9307.field_49404);
        if (bannerPatternsComponent.comp_2428().isEmpty() || (Integer)state.method_11654((class_2769)BasicBathtubBlock.LEVEL_8) == 0) {
            return class_1269.field_52423;
        }
        if (!world.field_9236) {
            class_1799 itemStack = stack.method_46651(1);
            itemStack.method_57379(class_9334.field_49619, (Object)bannerPatternsComponent.method_57571());
            if (!player.method_31549().field_7477) {
                stack.method_7934(1);
            }
            if (stack.method_7960()) {
                player.method_6122(hand, itemStack);
            } else if (player.method_31548().method_7394(itemStack)) {
                player.field_7498.method_34252();
            } else {
                player.method_7328(itemStack, false);
            }
            player.method_7281(class_3468.field_15390);
            BasicBathtubBlock.decrementFluidLevel(state, world, pos);
        }
        return class_1269.field_5812;
    };

    public static Object2ObjectOpenHashMap<class_1792, BathtubBehavior> createMap() {
        return (Object2ObjectOpenHashMap)class_156.method_654((Object)new Object2ObjectOpenHashMap(), map -> map.defaultReturnValue(null));
    }

    public class_1269 interact(class_2680 var1, class_1937 var2, class_2338 var3, class_1657 var4, class_1268 var5, class_1799 var6);

    public static class_1269 fillTub(class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_1799 stack, class_2680 state, class_3414 soundEvent, boolean usedBucket) {
        if (!world.field_9236) {
            int newLevel;
            player.method_7281(Statistics.BATHTUB_FILLED);
            if (usedBucket) {
                class_1792 item = stack.method_7909();
                player.method_6122(hand, class_5328.method_30012((class_1799)stack, (class_1657)player, (class_1799)new class_1799((class_1935)class_1802.field_8550)));
                player.method_7259(class_3468.field_15372.method_14956((Object)item));
            }
            if ((newLevel = (Integer)world.method_8320(pos).method_11654((class_2769)BasicBathtubBlock.LEVEL_8) + 4) >= 0 && newLevel <= 8) {
                world.method_8501(pos, (class_2680)state.method_11657((class_2769)BasicBathtubBlock.LEVEL_8, (Comparable)Integer.valueOf(newLevel)));
            } else {
                world.method_8501(pos, (class_2680)state.method_11657((class_2769)BasicBathtubBlock.LEVEL_8, (Comparable)Integer.valueOf(8)));
            }
            world.method_8396(null, pos, soundEvent, class_3419.field_15245, 1.0f, 1.0f);
        }
        return class_1269.field_5812;
    }

    public static class_1269 emptyTub(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_1799 stack, class_1799 output, Predicate<class_2680> predicate, class_3414 soundEvent) {
        if (!predicate.test(state)) {
            return class_1269.field_52423;
        }
        if (!world.field_9236) {
            class_1792 item = stack.method_7909();
            player.method_6122(hand, class_5328.method_30012((class_1799)stack, (class_1657)player, (class_1799)output));
            player.method_7281(Statistics.USE_BATHTUB);
            player.method_7259(class_3468.field_15372.method_14956((Object)item));
            int newLevel = (Integer)world.method_8320(pos).method_11654((class_2769)BasicBathtubBlock.LEVEL_8) - 4;
            if (newLevel >= 0) {
                world.method_8501(pos, (class_2680)state.method_11657((class_2769)BasicBathtubBlock.LEVEL_8, (Comparable)Integer.valueOf(newLevel)));
            } else {
                world.method_8501(pos, (class_2680)state.method_11657((class_2769)BasicBathtubBlock.LEVEL_8, (Comparable)Integer.valueOf(0)));
            }
            world.method_8396(null, pos, soundEvent, class_3419.field_15245, 1.0f, 1.0f);
        }
        return class_1269.field_5812;
    }

    public static void registerBucketBehavior(Map<class_1792, BathtubBehavior> behavior) {
        behavior.put(class_1802.field_8705, FILL_TUB_WITH_WATER);
    }

    public static void registerBehavior() {
        BathtubBehavior.registerBucketBehavior(TUB_BEHAVIOR);
        TUB_BEHAVIOR.put(class_1802.field_8550, (state2, world, pos, player, hand, stack) -> BathtubBehavior.emptyTub(state2, world, pos, player, hand, stack, new class_1799((class_1935)class_1802.field_8705), state -> (Integer)state.method_11654((class_2769)BasicBathtubBlock.LEVEL_8) >= 4, class_3417.field_15126));
        TUB_BEHAVIOR.put(class_1802.field_8469, (state, world, pos, player, hand, stack) -> {
            if (!world.field_9236) {
                if ((Integer)state.method_11654((class_2769)BasicBathtubBlock.LEVEL_8) == 0) {
                    return class_1269.field_52423;
                }
                class_1792 item = stack.method_7909();
                player.method_6122(hand, class_5328.method_30012((class_1799)stack, (class_1657)player, (class_1799)class_1844.method_57400((class_1792)class_1802.field_8574, (class_6880)class_1847.field_8991)));
                player.method_7281(Statistics.USE_BATHTUB);
                player.method_7259(class_3468.field_15372.method_14956((Object)item));
                BasicBathtubBlock.decrementFluidLevel(state, world, pos);
                world.method_8396(null, pos, class_3417.field_14779, class_3419.field_15245, 1.0f, 1.0f);
            }
            return class_1269.field_5812;
        });
        TUB_BEHAVIOR.put(class_1802.field_8574, (state, world, pos, player, hand, stack) -> {
            class_1844 potionContentsComponent = (class_1844)stack.method_58694(class_9334.field_49651);
            if ((Integer)state.method_11654((class_2769)BasicBathtubBlock.LEVEL_8) == 8 || potionContentsComponent != null && !potionContentsComponent.method_57401(class_1847.field_8991)) {
                return class_1269.field_52423;
            }
            if (!world.field_9236) {
                player.method_6122(hand, class_5328.method_30012((class_1799)stack, (class_1657)player, (class_1799)new class_1799((class_1935)class_1802.field_8469)));
                player.method_7281(Statistics.USE_BATHTUB);
                player.method_7259(class_3468.field_15372.method_14956((Object)stack.method_7909()));
                world.method_8501(pos, (class_2680)state.method_28493((class_2769)BasicBathtubBlock.LEVEL_8));
                world.method_8396(null, pos, class_3417.field_14826, class_3419.field_15245, 1.0f, 1.0f);
            }
            return class_1269.field_5812;
        });
        TUB_BEHAVIOR.put(class_1802.field_8370, CLEAN_DYEABLE_ITEM);
        TUB_BEHAVIOR.put(class_1802.field_8570, CLEAN_DYEABLE_ITEM);
        TUB_BEHAVIOR.put(class_1802.field_8577, CLEAN_DYEABLE_ITEM);
        TUB_BEHAVIOR.put(class_1802.field_8267, CLEAN_DYEABLE_ITEM);
        TUB_BEHAVIOR.put(class_1802.field_18138, CLEAN_DYEABLE_ITEM);
        TUB_BEHAVIOR.put(class_1802.field_8539, CLEAN_BANNER);
        TUB_BEHAVIOR.put(class_1802.field_8617, CLEAN_BANNER);
        TUB_BEHAVIOR.put(class_1802.field_8572, CLEAN_BANNER);
        TUB_BEHAVIOR.put(class_1802.field_8128, CLEAN_BANNER);
        TUB_BEHAVIOR.put(class_1802.field_8124, CLEAN_BANNER);
        TUB_BEHAVIOR.put(class_1802.field_8629, CLEAN_BANNER);
        TUB_BEHAVIOR.put(class_1802.field_8295, CLEAN_BANNER);
        TUB_BEHAVIOR.put(class_1802.field_8379, CLEAN_BANNER);
        TUB_BEHAVIOR.put(class_1802.field_8855, CLEAN_BANNER);
        TUB_BEHAVIOR.put(class_1802.field_8778, CLEAN_BANNER);
        TUB_BEHAVIOR.put(class_1802.field_8671, CLEAN_BANNER);
        TUB_BEHAVIOR.put(class_1802.field_8824, CLEAN_BANNER);
        TUB_BEHAVIOR.put(class_1802.field_8329, CLEAN_BANNER);
        TUB_BEHAVIOR.put(class_1802.field_8405, CLEAN_BANNER);
        TUB_BEHAVIOR.put(class_1802.field_8586, CLEAN_BANNER);
        TUB_BEHAVIOR.put(class_1802.field_8049, CLEAN_BANNER);
        TUB_BEHAVIOR.put(class_1802.field_8722, CLEAN_SHULKER_BOX);
        TUB_BEHAVIOR.put(class_1802.field_8627, CLEAN_SHULKER_BOX);
        TUB_BEHAVIOR.put(class_1802.field_8268, CLEAN_SHULKER_BOX);
        TUB_BEHAVIOR.put(class_1802.field_8350, CLEAN_SHULKER_BOX);
        TUB_BEHAVIOR.put(class_1802.field_8584, CLEAN_SHULKER_BOX);
        TUB_BEHAVIOR.put(class_1802.field_8213, CLEAN_SHULKER_BOX);
        TUB_BEHAVIOR.put(class_1802.field_8461, CLEAN_SHULKER_BOX);
        TUB_BEHAVIOR.put(class_1802.field_8829, CLEAN_SHULKER_BOX);
        TUB_BEHAVIOR.put(class_1802.field_8451, CLEAN_SHULKER_BOX);
        TUB_BEHAVIOR.put(class_1802.field_8548, CLEAN_SHULKER_BOX);
        TUB_BEHAVIOR.put(class_1802.field_8050, CLEAN_SHULKER_BOX);
        TUB_BEHAVIOR.put(class_1802.field_8380, CLEAN_SHULKER_BOX);
        TUB_BEHAVIOR.put(class_1802.field_8520, CLEAN_SHULKER_BOX);
        TUB_BEHAVIOR.put(class_1802.field_8816, CLEAN_SHULKER_BOX);
        TUB_BEHAVIOR.put(class_1802.field_8676, CLEAN_SHULKER_BOX);
        TUB_BEHAVIOR.put(class_1802.field_8271, CLEAN_SHULKER_BOX);
    }
}

