/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.config.option;

import com.unlikepaladin.pfm.config.option.AbstractConfigOption;
import com.unlikepaladin.pfm.config.option.ConfigSizeTracker;
import com.unlikepaladin.pfm.config.option.NullConfigOption;
import java.io.DataInput;
import java.io.IOException;

public interface ConfigOptionType<T extends AbstractConfigOption> {
    public T read(DataInput var1, int var2, ConfigSizeTracker var3) throws IOException;

    default public boolean isImmutable() {
        return false;
    }

    public String getCrashReportName();

    public static ConfigOptionType<NullConfigOption> createInvalid(final int type) {
        return new ConfigOptionType<NullConfigOption>(){

            @Override
            public String getCrashReportName() {
                return "INVALID[" + type + "]";
            }

            @Override
            public NullConfigOption read(DataInput input, int depth, ConfigSizeTracker tracker) throws IOException {
                throw new IllegalArgumentException("Invalid Config id: " + type);
            }
        };
    }
}

