/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.data.materials;

import com.unlikepaladin.pfm.data.materials.StoneVariant;
import com.unlikepaladin.pfm.data.materials.VariantBase;
import com.unlikepaladin.pfm.data.materials.VariantRegistryBase;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.class_2231;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2482;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2766;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class StoneVariantRegistry
extends VariantRegistryBase<StoneVariant> {
    public static final StoneVariant STONE = new StoneVariant(class_2960.method_60654((String)"stone"), class_2246.field_10340, class_2246.field_10445);
    public static final StoneVariantRegistry INSTANCE = new StoneVariantRegistry();

    public static Collection<String> getNamespaces() {
        return StoneVariantRegistry.INSTANCE.variants.values().stream().map(VariantBase::getNamespace).collect(Collectors.toUnmodifiableList());
    }

    public static Collection<StoneVariant> getVariants() {
        return Collections.unmodifiableCollection(StoneVariantRegistry.INSTANCE.variants.values());
    }

    @Nullable
    public static StoneVariant getVariant(class_2960 name) {
        return StoneVariantRegistry.INSTANCE.variants.getOrDefault(name, STONE);
    }

    public static Optional<StoneVariant> getOptionalVariant(class_2960 name) {
        return StoneVariantRegistry.INSTANCE.variants.containsKey(name) ? Optional.of((StoneVariant)StoneVariantRegistry.INSTANCE.variants.get(name)) : Optional.empty();
    }

    @Override
    public Optional<StoneVariant> getVariantFromBlock(class_2248 baseBlock, class_2960 blockId) {
        class_2680 state;
        String name = null;
        String path = blockId.method_12832();
        if (blockId.method_12836().equals("tfc")) {
            Optional cobble;
            if (path.contains("rock/polished/") && (cobble = class_7923.field_41175.method_17966(class_2960.method_60655((String)blockId.method_12836(), (String)path.replace("polished", "raw")))).isPresent()) {
                class_2960 id = class_2960.method_60655((String)blockId.method_12836(), (String)path.replace("rock/polished/", ""));
                return Optional.of(new StoneVariant(id, baseBlock, (class_2248)cobble.get()));
            }
            return Optional.empty();
        }
        if (path.endsWith("_polished")) {
            name = path.substring(0, path.length() - "_polished".length());
        } else if (path.startsWith("polished_")) {
            name = path.substring("polished_".length());
        } else if (path.endsWith("_polish")) {
            name = path.substring(0, path.length() - "_polish".length());
        } else if (path.startsWith("polish_")) {
            name = path.substring("polish_".length());
        }
        String namespace = blockId.method_12836();
        if (!(namespace.equals("cozy_home") || namespace.equals("adorn") || name == null || namespace.equals("securitycraft") || namespace.equals("absentbydesign") || namespace.equals("chipped") || namespace.equals("polydecorations") || namespace.equals("extshape") || namespace.equals("modernlife") || namespace.equals("ars_nouveau") && path.contains("sconce") || namespace.equals("excessive_building") || (state = baseBlock.method_9564()).method_28501().size() > 2 || baseBlock instanceof class_2482 || name.contains("slab") || baseBlock instanceof class_2231 || name.contains("pressure_plate"))) {
            class_2498 soundGroup = state.method_26231();
            class_2766 instrument = state.method_51364();
            if (soundGroup == class_2498.field_29033 || soundGroup == class_2498.field_29036 || soundGroup == class_2498.field_11544 || instrument == class_2766.field_12653) {
                name = name.replace("/", "_");
                class_2960 id = class_2960.method_60655((String)blockId.method_12836(), (String)name);
                class_2248 rawBlock = StoneVariantRegistry.findRaw(id);
                if (rawBlock != null) {
                    return Optional.of(new StoneVariant(id, baseBlock, rawBlock));
                }
            }
        }
        return Optional.empty();
    }

    @Override
    public StoneVariant getDefaultType() {
        return STONE;
    }

    @Override
    public Class<StoneVariant> getType() {
        return StoneVariant.class;
    }

    @Nullable
    private static class_2248 findRaw(class_2960 id) {
        class_2960[] test = new class_2960[]{class_2960.method_60655((String)id.method_12836(), (String)id.method_12832()), class_2960.method_60655((String)id.method_12836(), (String)(id.method_12832() + "raw")), class_2960.method_60655((String)id.method_12836(), (String)(id.method_12832() + "_raw")), class_2960.method_60655((String)id.method_12836(), (String)("raw_" + id.method_12832())), class_2960.method_60655((String)id.method_12836(), (String)("raw" + id.method_12832())), class_2960.method_60655((String)id.method_12836(), (String)(id.method_12832() + "_cobble")), class_2960.method_60655((String)id.method_12836(), (String)(id.method_12832() + "cobble")), class_2960.method_60655((String)id.method_12836(), (String)("cobble_" + id.method_12832())), class_2960.method_60655((String)id.method_12836(), (String)("cobble" + id.method_12832())), class_2960.method_60654((String)id.method_12832()), class_2960.method_60654((String)(id.method_12832() + "raw")), class_2960.method_60654((String)(id.method_12832() + "_raw")), class_2960.method_60654((String)("raw_" + id.method_12832())), class_2960.method_60654((String)("raw" + id.method_12832())), class_2960.method_60654((String)(id.method_12832() + "_cobble")), class_2960.method_60654((String)(id.method_12832() + "cobble")), class_2960.method_60654((String)("cobble_" + id.method_12832())), class_2960.method_60654((String)("cobble" + id.method_12832()))};
        class_2248 temp = null;
        for (class_2960 r : test) {
            if (!class_7923.field_41175.method_10250(r)) continue;
            temp = (class_2248)class_7923.field_41175.method_63535(r);
            break;
        }
        return temp;
    }
}

