/*
 * Decompiled with CFR 0.152.
 */
package com.unlikepaladin.pfm.registry.dynamic;

import com.unlikepaladin.pfm.blocks.DyeableFurnitureBlock;
import com.unlikepaladin.pfm.data.materials.VariantBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1767;
import net.minecraft.class_2248;
import net.minecraft.class_2960;

public class FurnitureEntry<T extends class_2248> {
    private final HashMap<VariantBase<?>, Set<T>> variantToBlockMapList = new LinkedHashMap();
    private final HashMap<VariantBase<?>, T> variantToBlockMap = new LinkedHashMap();
    private final HashMap<VariantBase<?>, T> variantToBlockMapNonBase = new LinkedHashMap();
    final List<T> allBlocks = new ArrayList<T>();
    private Class<T> type;

    public <J extends class_2248> void addBlock(VariantBase variantBase, J block1, boolean base) {
        J block;
        if (block1 != null) {
            block = block1;
            if (base) {
                this.variantToBlockMap.put(variantBase, block);
            } else {
                this.variantToBlockMapNonBase.put(variantBase, block);
            }
            if (!this.variantToBlockMapList.containsKey(variantBase)) {
                this.variantToBlockMapList.put(variantBase, new HashSet());
            }
        } else {
            throw new UnsupportedOperationException("Block was not instance of T");
        }
        this.variantToBlockMapList.get(variantBase).add(block);
        this.allBlocks.add(block);
        this.type = block1.getClass();
    }

    public Optional<class_2248> getEntryFromVariant(VariantBase<?> variant) {
        return this.getEntryFromVariant(variant, false);
    }

    public Optional<class_2248> getEntryFromVariantAndColor(VariantBase<?> variant, class_1767 color) {
        if (this.variantToBlockMapList.containsKey(variant)) {
            for (class_2248 block : this.variantToBlockMapList.get(variant)) {
                DyeableFurnitureBlock dyeableFurnitureBlock;
                if (!(block instanceof DyeableFurnitureBlock) || (dyeableFurnitureBlock = (DyeableFurnitureBlock)block).getPFMColor() != color) continue;
                return Optional.of(block);
            }
        }
        return this.getEntryFromVariant(variant, false);
    }

    public List<class_2960> getVariants() {
        return this.variantToBlockMap.keySet().stream().map(variantBase -> variantBase.identifier).toList();
    }

    public Optional<class_2248> getEntryFromVariant(VariantBase<?> variant, boolean stripped) {
        if (!stripped && this.variantToBlockMap.containsKey(variant)) {
            return Optional.of((class_2248)this.variantToBlockMap.get(variant));
        }
        if (this.variantToBlockMapNonBase.containsKey(variant)) {
            return Optional.of((class_2248)this.variantToBlockMapNonBase.get(variant));
        }
        return Optional.empty();
    }

    public VariantBase<?> getVariantFromEntry(class_2248 block) {
        if (block.getClass() == this.getTClass()) {
            for (Map.Entry<VariantBase<?>, T> entry : this.variantToBlockMap.entrySet()) {
                if (!((class_2248)entry.getValue()).equals(block)) continue;
                return entry.getKey();
            }
            for (Map.Entry<VariantBase<?>, T> entry : this.variantToBlockMapNonBase.entrySet()) {
                if (!((class_2248)entry.getValue()).equals(block)) continue;
                return entry.getKey();
            }
            for (Map.Entry<VariantBase<?>, Object> entry : this.variantToBlockMapList.entrySet()) {
                if (!((Set)entry.getValue()).contains(block)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    public void addBlock(T block) {
        if (block == null) {
            throw new UnsupportedOperationException("Block was not instance of T");
        }
        this.allBlocks.add(block);
    }

    public HashMap<VariantBase<?>, T> getVariantToBlockMap() {
        return this.variantToBlockMap;
    }

    public HashMap<VariantBase<?>, T> getVariantToBlockMapNonBase() {
        return this.variantToBlockMapNonBase;
    }

    public Optional<T> getFromIdentifier(class_2960 identifier, boolean base) {
        if (base) {
            for (VariantBase<?> variantBase : this.variantToBlockMap.keySet()) {
                if (!variantBase.identifier.equals((Object)identifier)) continue;
                return Optional.of((class_2248)this.variantToBlockMap.get(variantBase));
            }
        } else {
            for (VariantBase<?> variantBase : this.variantToBlockMapNonBase.keySet()) {
                if (!variantBase.identifier.equals((Object)identifier)) continue;
                return Optional.of((class_2248)this.variantToBlockMapNonBase.get(variantBase));
            }
        }
        for (class_2248 block : this.allBlocks) {
            if (!block.method_63499().contains(identifier.method_12832())) continue;
            return Optional.of(block);
        }
        return Optional.empty();
    }

    public HashMap<VariantBase<?>, Set<T>> getVariantToBlockMapList() {
        return this.variantToBlockMapList;
    }

    public List<T> getAllBlocks() {
        return this.allBlocks;
    }

    public Class<T> getTClass() {
        return this.type;
    }
}

