/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.pipeline;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import it.unimi.dsi.fastutil.Function;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import java.util.Map;
import net.caffeinemc.mods.sodium.client.render.immediate.CloudRenderer;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.pathways.HandRenderer;
import net.irisshaders.iris.pipeline.IrisRenderingPipeline;
import net.irisshaders.iris.pipeline.programs.ShaderKey;
import net.irisshaders.iris.pipeline.programs.ShaderOverrides;
import net.irisshaders.iris.shadows.ShadowRenderingState;
import net.minecraft.class_10799;
import org.jetbrains.annotations.Nullable;

public class IrisPipelines {
    private static final Map<RenderPipeline, Function<IrisRenderingPipeline, ShaderKey>> coreShaderMap = new Object2ObjectArrayMap();
    private static final Map<RenderPipeline, Function<IrisRenderingPipeline, ShaderKey>> coreShaderMapShadow = new Object2ObjectArrayMap();
    private static final Function<IrisRenderingPipeline, ShaderKey> FAKE_FUNCTION = p -> null;

    private static ShaderKey getText(Object p) {
        IrisRenderingPipeline pipeline = (IrisRenderingPipeline)p;
        if (ShaderOverrides.isBlockEntities(pipeline)) {
            return ShaderKey.TEXT_BE;
        }
        return ShaderKey.TEXT;
    }

    private static ShaderKey getTextIntensity(Object p) {
        IrisRenderingPipeline pipeline = (IrisRenderingPipeline)p;
        if (ShaderOverrides.isBlockEntities(pipeline)) {
            return ShaderKey.TEXT_INTENSITY_BE;
        }
        return ShaderKey.TEXT_INTENSITY;
    }

    private static void assignToMain(RenderPipeline pipeline, Function<IrisRenderingPipeline, ShaderKey> o) {
        ShaderKey newKey;
        Function<IrisRenderingPipeline, ShaderKey> current;
        ShaderKey currentKey;
        if (coreShaderMap.containsKey(pipeline) && (currentKey = (ShaderKey)((Object)(current = coreShaderMap.get(pipeline)).apply(null))) != (newKey = (ShaderKey)((Object)o.apply(null)))) {
            Iris.logger.warn("Pair already assigned: " + String.valueOf(pipeline) + " to " + String.valueOf((Object)currentKey) + " -> " + String.valueOf((Object)newKey));
        }
        coreShaderMap.put(pipeline, o);
    }

    private static void assignToShadow(RenderPipeline pipeline, Function<IrisRenderingPipeline, ShaderKey> o) {
        if (coreShaderMapShadow.containsKey(pipeline)) {
            Iris.logger.warn("Pair already assigned: " + String.valueOf(pipeline));
        }
        coreShaderMapShadow.put(pipeline, o);
    }

    private static ShaderKey getCutout(Object p) {
        IrisRenderingPipeline pipeline = (IrisRenderingPipeline)p;
        if (HandRenderer.INSTANCE.isActive()) {
            return HandRenderer.INSTANCE.isRenderingSolid() ? ShaderKey.HAND_CUTOUT_DIFFUSE : ShaderKey.HAND_WATER_DIFFUSE;
        }
        if (ShaderOverrides.isBlockEntities(pipeline)) {
            return ShaderKey.BLOCK_ENTITY_DIFFUSE;
        }
        return ShaderKey.ENTITIES_CUTOUT_DIFFUSE;
    }

    private static ShaderKey getSolid(Object p) {
        IrisRenderingPipeline pipeline = (IrisRenderingPipeline)p;
        if (HandRenderer.INSTANCE.isActive()) {
            return HandRenderer.INSTANCE.isRenderingSolid() ? ShaderKey.HAND_CUTOUT : ShaderKey.HAND_TRANSLUCENT;
        }
        if (ShaderOverrides.isBlockEntities(pipeline)) {
            return ShaderKey.BLOCK_ENTITY;
        }
        return ShaderKey.ENTITIES_SOLID;
    }

    private static ShaderKey getTranslucent(Object p) {
        IrisRenderingPipeline pipeline = (IrisRenderingPipeline)p;
        if (HandRenderer.INSTANCE.isActive()) {
            return HandRenderer.INSTANCE.isRenderingSolid() ? ShaderKey.HAND_CUTOUT_DIFFUSE : ShaderKey.HAND_WATER_DIFFUSE;
        }
        if (ShaderOverrides.isBlockEntities(pipeline)) {
            return ShaderKey.BLOCK_ENTITY;
        }
        return ShaderKey.ENTITIES_TRANSLUCENT;
    }

    @Nullable
    public static ShaderKey getPipeline(IrisRenderingPipeline pipeline, RenderPipeline shader) {
        if (ShadowRenderingState.areShadowsCurrentlyBeingRendered()) {
            return (ShaderKey)((Object)coreShaderMapShadow.getOrDefault(shader, FAKE_FUNCTION).apply((Object)pipeline));
        }
        return (ShaderKey)((Object)coreShaderMap.getOrDefault(shader, FAKE_FUNCTION).apply((Object)pipeline));
    }

    public static void assignPipeline(RenderPipeline pipeline, ShaderKey programId) {
        if (coreShaderMap.containsKey(pipeline)) {
            throw new IllegalStateException("Shader already assigned: " + String.valueOf(pipeline.getLocation()) + ": " + String.valueOf((Object)programId));
        }
        coreShaderMap.put(pipeline, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> programId));
    }

    public static void copyPipeline(RenderPipeline pipelineToCopy, RenderPipeline returnValue) {
        if (coreShaderMap.containsKey(pipelineToCopy)) {
            coreShaderMap.put(returnValue, coreShaderMap.get(pipelineToCopy));
        }
        if (coreShaderMapShadow.containsKey(pipelineToCopy)) {
            coreShaderMapShadow.put(returnValue, coreShaderMapShadow.get(pipelineToCopy));
        }
    }

    static {
        IrisPipelines.assignToMain(class_10799.field_56891, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.TERRAIN_SOLID));
        IrisPipelines.assignToMain(class_10799.field_56894, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.TERRAIN_CUTOUT));
        IrisPipelines.assignToMain(class_10799.field_56893, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.TERRAIN_CUTOUT));
        IrisPipelines.assignToMain(class_10799.field_56895, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.TERRAIN_TRANSLUCENT));
        IrisPipelines.assignToMain(class_10799.field_56897, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.MOVING_BLOCK));
        IrisPipelines.assignToMain(class_10799.field_56896, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.TERRAIN_TRANSLUCENT));
        IrisPipelines.assignToMain(class_10799.field_56869, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.TEXTURED));
        IrisPipelines.assignToMain(class_10799.field_56903, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> IrisPipelines.getCutout(p)));
        IrisPipelines.assignToMain(class_10799.field_56904, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> IrisPipelines.getCutout(p)));
        IrisPipelines.assignToMain(class_10799.field_56905, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> IrisPipelines.getCutout(p)));
        IrisPipelines.assignToMain(class_10799.field_56908, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> IrisPipelines.getCutout(p)));
        IrisPipelines.assignToMain(class_10799.field_56915, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> IrisPipelines.getTranslucent(p)));
        IrisPipelines.assignToMain(class_10799.field_56906, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> IrisPipelines.getTranslucent(p)));
        IrisPipelines.assignToMain(class_10799.field_56914, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> IrisPipelines.getTranslucent(p)));
        IrisPipelines.assignToMain(class_10799.field_56909, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> IrisPipelines.getTranslucent(p)));
        IrisPipelines.assignToMain(class_10799.field_56913, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> IrisPipelines.getCutout(p)));
        IrisPipelines.assignToMain(class_10799.field_56833, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.LINES));
        IrisPipelines.assignToMain(class_10799.field_56835, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.LINES));
        IrisPipelines.assignToMain(class_10799.field_56834, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.LINES));
        IrisPipelines.assignToMain(class_10799.field_56877, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SKY_BASIC));
        IrisPipelines.assignToMain(class_10799.field_56876, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SKY_BASIC_COLOR));
        IrisPipelines.assignToMain(class_10799.field_56874, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SKY_BASIC));
        IrisPipelines.assignToMain(class_10799.field_56878, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SKY_TEXTURED_COLOR));
        IrisPipelines.assignToMain(class_10799.field_56870, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.PARTICLES));
        IrisPipelines.assignToMain(class_10799.field_56871, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.PARTICLES_TRANS));
        IrisPipelines.assignToMain(class_10799.field_56815, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.BASIC));
        IrisPipelines.assignToMain(class_10799.field_56816, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.GLINT));
        IrisPipelines.assignToMain(class_10799.field_56898, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> IrisPipelines.getCutout(p)));
        IrisPipelines.assignToMain(class_10799.field_56912, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.ENTITIES_EYES));
        IrisPipelines.assignToMain(class_10799.field_56907, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.ENTITIES_EYES_TRANS));
        IrisPipelines.assignToMain(class_10799.field_56899, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> IrisPipelines.getCutout(p)));
        IrisPipelines.assignToMain(class_10799.field_56900, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> IrisPipelines.getTranslucent(p)));
        IrisPipelines.assignToMain(class_10799.field_56910, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> IrisPipelines.getTranslucent(p)));
        IrisPipelines.assignToMain(class_10799.field_56901, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> IrisPipelines.getSolid(p)));
        IrisPipelines.assignToMain(class_10799.field_56902, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> IrisPipelines.getSolid(p)));
        IrisPipelines.assignToMain(class_10799.field_56829, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.BLOCK_ENTITY));
        IrisPipelines.assignToMain(class_10799.field_56911, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.ENTITIES_CUTOUT));
        IrisPipelines.assignToMain(class_10799.field_56825, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.LIGHTNING));
        IrisPipelines.assignToMain(class_10799.field_56826, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.LIGHTNING));
        IrisPipelines.assignToMain(class_10799.field_56827, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.LIGHTNING));
        IrisPipelines.assignToMain(class_10799.field_56916, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.BEACON));
        IrisPipelines.assignToMain(class_10799.field_56812, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.BEACON));
        IrisPipelines.assignToMain(class_10799.field_56828, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.BLOCK_ENTITY));
        IrisPipelines.assignToMain(class_10799.field_56875, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SKY_TEXTURED));
        IrisPipelines.assignToMain(class_10799.field_56872, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.WEATHER));
        IrisPipelines.assignToMain(class_10799.field_56873, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.WEATHER));
        IrisPipelines.assignToMain(class_10799.field_56818, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> IrisPipelines.getText(p)));
        IrisPipelines.assignToMain(class_10799.field_56821, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> IrisPipelines.getText(p)));
        IrisPipelines.assignToMain(class_10799.field_56822, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> IrisPipelines.getText(p)));
        IrisPipelines.assignToMain(class_10799.field_56824, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> IrisPipelines.getTextIntensity(p)));
        IrisPipelines.assignToMain(class_10799.field_56819, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.TEXT_BG));
        IrisPipelines.assignToMain(class_10799.field_56823, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.TEXT_BG));
        IrisPipelines.assignToMain(class_10799.field_56820, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> IrisPipelines.getTextIntensity(p)));
        IrisPipelines.assignToMain(class_10799.field_56813, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.ENTITIES_ALPHA));
        IrisPipelines.assignToMain(class_10799.field_56817, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.CRUMBLING));
        IrisPipelines.assignToMain(class_10799.field_56814, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.LEASH));
        IrisPipelines.assignToMain(CloudRenderer.CLOUDS_FLAT, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.CLOUDS_SODIUM));
        IrisPipelines.assignToMain(CloudRenderer.CLOUDS_FULL, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.CLOUDS_SODIUM));
        IrisPipelines.assignToMain(class_10799.field_56836, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.BASIC_COLOR));
        IrisPipelines.assignToShadow(class_10799.field_56891, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_TERRAIN_CUTOUT));
        IrisPipelines.assignToShadow(class_10799.field_56894, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_TERRAIN_CUTOUT));
        IrisPipelines.assignToShadow(class_10799.field_56893, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_TERRAIN_CUTOUT));
        IrisPipelines.assignToShadow(class_10799.field_56895, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_TRANSLUCENT));
        IrisPipelines.assignToShadow(class_10799.field_56897, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_TRANSLUCENT));
        IrisPipelines.assignToShadow(class_10799.field_56896, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_TRANSLUCENT));
        IrisPipelines.assignToShadow(class_10799.field_56903, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        IrisPipelines.assignToShadow(class_10799.field_56898, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        IrisPipelines.assignToShadow(class_10799.field_56915, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        IrisPipelines.assignToShadow(class_10799.field_56899, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        IrisPipelines.assignToShadow(class_10799.field_56901, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        IrisPipelines.assignToShadow(class_10799.field_56817, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_TEX));
        IrisPipelines.assignToShadow(class_10799.field_56902, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        IrisPipelines.assignToShadow(class_10799.field_56904, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        IrisPipelines.assignToShadow(class_10799.field_56905, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        IrisPipelines.assignToShadow(class_10799.field_56908, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        IrisPipelines.assignToShadow(class_10799.field_56906, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        IrisPipelines.assignToShadow(class_10799.field_56907, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        IrisPipelines.assignToShadow(class_10799.field_56910, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        IrisPipelines.assignToShadow(class_10799.field_56912, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        IrisPipelines.assignToShadow(class_10799.field_56813, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        IrisPipelines.assignToShadow(class_10799.field_56909, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        IrisPipelines.assignToShadow(class_10799.field_56911, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        IrisPipelines.assignToShadow(class_10799.field_56913, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        IrisPipelines.assignToShadow(class_10799.field_56816, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        IrisPipelines.assignToShadow(class_10799.field_56872, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_PARTICLES));
        IrisPipelines.assignToShadow(class_10799.field_56873, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_PARTICLES));
        IrisPipelines.assignToShadow(class_10799.field_56870, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_PARTICLES));
        IrisPipelines.assignToShadow(class_10799.field_56871, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_PARTICLES));
        IrisPipelines.assignToShadow(class_10799.field_56833, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_LINES));
        IrisPipelines.assignToShadow(class_10799.field_56835, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_LINES));
        IrisPipelines.assignToShadow(class_10799.field_56814, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_LEASH));
        IrisPipelines.assignToShadow(class_10799.field_56834, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_LINES));
        IrisPipelines.assignToShadow(class_10799.field_56818, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_TEXT));
        IrisPipelines.assignToShadow(class_10799.field_56821, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_TEXT));
        IrisPipelines.assignToShadow(class_10799.field_56822, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_TEXT));
        IrisPipelines.assignToShadow(class_10799.field_56824, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_TEXT_INTENSITY));
        IrisPipelines.assignToShadow(class_10799.field_56819, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_TEXT_BG));
        IrisPipelines.assignToShadow(class_10799.field_56823, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_TEXT_BG));
        IrisPipelines.assignToShadow(class_10799.field_56820, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_TEXT_INTENSITY));
        IrisPipelines.assignToShadow(class_10799.field_56815, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_BASIC));
        IrisPipelines.assignToShadow(class_10799.field_56916, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_BEACON_BEAM));
        IrisPipelines.assignToShadow(class_10799.field_56812, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_BEACON_BEAM));
        IrisPipelines.assignToShadow(class_10799.field_56828, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_BLOCK));
        IrisPipelines.assignToShadow(class_10799.field_56829, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_BLOCK));
        IrisPipelines.assignToShadow(class_10799.field_56900, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_ENTITIES_CUTOUT));
        IrisPipelines.assignToShadow(class_10799.field_56825, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.SHADOW_LIGHTNING));
        IrisPipelines.assignToShadow(CloudRenderer.CLOUDS_FLAT, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.CLOUDS_SODIUM));
        IrisPipelines.assignToShadow(CloudRenderer.CLOUDS_FULL, (Function<IrisRenderingPipeline, ShaderKey>)((Function)p -> ShaderKey.CLOUDS_SODIUM));
    }
}

