/*
 * Decompiled with CFR 0.152.
 */
package me.cominixo.betterf3.modules;

import com.mojang.blaze3d.platform.GLX;
import com.mojang.blaze3d.systems.GpuDevice;
import com.mojang.blaze3d.systems.RenderSystem;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.concurrent.TimeUnit;
import me.cominixo.betterf3.modules.BaseModule;
import me.cominixo.betterf3.utils.DebugLine;
import me.cominixo.betterf3.utils.Utils;
import net.minecraft.class_1041;
import net.minecraft.class_124;
import net.minecraft.class_310;
import net.minecraft.class_5251;
import org.jetbrains.annotations.NotNull;

public class SystemModule
extends BaseModule {
    public final boolean defaultMemoryColorToggle = true;
    public Boolean memoryColorToggle;
    public final String defaultTimeFormat = "HH:mm:ss";
    public String timeFormat;
    private static final List<GarbageCollectorMXBean> GARBAGE_COLLECTORS = ManagementFactory.getGarbageCollectorMXBeans();
    private long lastCalculated = 0L;
    private long allocatedBytes = -1L;
    private long collectionCount = -1L;
    private long allocationRate = 0L;

    public SystemModule() {
        this.defaultNameColor = class_5251.method_27718((class_124)class_124.field_1065);
        this.defaultValueColor = class_5251.method_27718((class_124)class_124.field_1075);
        this.nameColor = this.defaultNameColor;
        this.valueColor = this.defaultValueColor;
        this.memoryColorToggle = this.defaultMemoryColorToggle;
        this.timeFormat = this.defaultTimeFormat;
        this.lines.add(new DebugLine("time"));
        this.lines.add(new DebugLine("java_version"));
        this.lines.add(new DebugLine("memory_usage"));
        this.lines.add(new DebugLine("allocation_rate"));
        this.lines.add(new DebugLine("allocated_memory"));
        this.lines.add(new DebugLine("cpu"));
        this.lines.add(new DebugLine("display"));
        this.lines.add(new DebugLine("gpu"));
        this.lines.add(new DebugLine("gpu_utilization"));
        this.lines.add(new DebugLine("opengl_version"));
        this.lines.add(new DebugLine("gpu_driver"));
        for (DebugLine line : this.lines) {
            line.inReducedDebug = true;
        }
    }

    @Override
    public void update(class_310 client) {
        DateTimeFormatter timeFormatter;
        LocalDateTime currentTime = LocalDateTime.now();
        try {
            timeFormatter = DateTimeFormatter.ofPattern(this.timeFormat);
        }
        catch (IllegalArgumentException e) {
            this.timeFormat = this.defaultTimeFormat;
            timeFormatter = DateTimeFormatter.ofPattern(this.timeFormat);
        }
        String time = currentTime.format(timeFormatter);
        long maxMemory = Runtime.getRuntime().maxMemory();
        long totalMemory = Runtime.getRuntime().totalMemory();
        long freeMemory = Runtime.getRuntime().freeMemory();
        long usedMemory = totalMemory - freeMemory;
        class_1041 window = client.method_22683();
        GpuDevice gpuDevice = RenderSystem.getDevice();
        String javaVersion = String.format("%s", System.getProperty("java.version"));
        String memoryUsage = String.format("% 2d%% %03d/%03d MB", usedMemory * 100L / maxMemory, usedMemory / 1024L / 1024L, maxMemory / 1024L / 1024L);
        String allocationRate = String.format("% 2d MB/s", this.allocationRate(usedMemory) / 1024L / 1024L);
        String allocatedMemory = String.format("% 2d%% %03dMB", totalMemory * 100L / maxMemory, totalMemory / 1024L / 1024L);
        String displayInfo = String.format("%d x %d (%s)", window.method_4489(), window.method_4506(), gpuDevice.getVendor());
        String openGlVersion = gpuDevice.getBackendName();
        String gpuDriverVersion = gpuDevice.getVersion();
        String gpuUtilization = SystemModule.gpuUtilization();
        ((DebugLine)this.lines.get(0)).value(time);
        ((DebugLine)this.lines.get(1)).value(javaVersion);
        ((DebugLine)this.lines.get(2)).value(this.memoryColorToggle != false ? String.valueOf(Utils.percentColor((int)(usedMemory * 100L / maxMemory))) + memoryUsage : memoryUsage);
        ((DebugLine)this.lines.get(3)).value(allocationRate);
        ((DebugLine)this.lines.get(4)).value(allocatedMemory);
        ((DebugLine)this.lines.get(5)).value(GLX._getCpuInfo());
        ((DebugLine)this.lines.get(6)).value(displayInfo);
        ((DebugLine)this.lines.get(7)).value(gpuDevice.getRenderer());
        ((DebugLine)this.lines.get(8)).value(gpuUtilization);
        ((DebugLine)this.lines.get(9)).value(openGlVersion);
        ((DebugLine)this.lines.get(10)).value(gpuDriverVersion);
    }

    long allocationRate(long allocatedBytes) {
        long lastCalculated = System.currentTimeMillis();
        if (lastCalculated - this.lastCalculated >= 500L) {
            long collectionCount = SystemModule.collectionCount();
            if (this.lastCalculated != 0L && collectionCount == this.collectionCount) {
                double d = (double)TimeUnit.SECONDS.toMillis(1L) / (double)(lastCalculated - this.lastCalculated);
                long n = allocatedBytes - this.allocatedBytes;
                this.allocationRate = Math.round((double)n * d);
            }
            this.lastCalculated = lastCalculated;
            this.allocatedBytes = allocatedBytes;
            this.collectionCount = collectionCount;
        }
        return this.allocationRate;
    }

    private static long collectionCount() {
        long l = 0L;
        for (GarbageCollectorMXBean garbageCollectorMXBean : GARBAGE_COLLECTORS) {
            l += garbageCollectorMXBean.getCollectionCount();
        }
        return l;
    }

    @NotNull
    private static String gpuUtilization() {
        double gpuUtilizationPercentage = class_310.method_1551().method_41734();
        if (gpuUtilizationPercentage > 0.0) {
            return gpuUtilizationPercentage > 100.0 ? String.valueOf(class_124.field_1061) + "100%" : Math.round(gpuUtilizationPercentage) + "%";
        }
        return "N/A";
    }
}

