/*
 * Decompiled with CFR 0.152.
 */
package squeek.appleskin.network;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1928;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import squeek.appleskin.helpers.ExhaustionHelper;
import squeek.appleskin.network.ExhaustionSyncPayload;
import squeek.appleskin.network.NaturalRegenerationSyncPayload;
import squeek.appleskin.network.SaturationSyncPayload;

public class SyncHandler {
    private static final Map<UUID, Float> lastSaturationLevels = new HashMap<UUID, Float>();
    private static final Map<UUID, Float> lastExhaustionLevels = new HashMap<UUID, Float>();
    private static boolean naturalRegeneration = true;

    public static void init() {
        PayloadTypeRegistry.playS2C().register(ExhaustionSyncPayload.ID, ExhaustionSyncPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(SaturationSyncPayload.ID, SaturationSyncPayload.CODEC);
        PayloadTypeRegistry.playS2C().register(NaturalRegenerationSyncPayload.ID, NaturalRegenerationSyncPayload.CODEC);
        ServerTickEvents.END_WORLD_TICK.register(SyncHandler::onServerWorldTick);
    }

    public static void onPlayerUpdate(class_3222 player) {
        Float lastSaturationLevel = lastSaturationLevels.get(player.method_5667());
        Float lastExhaustionLevel = lastExhaustionLevels.get(player.method_5667());
        float saturation = player.method_7344().method_7589();
        if (lastSaturationLevel == null || lastSaturationLevel.floatValue() != saturation) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)new SaturationSyncPayload(saturation));
            lastSaturationLevels.put(player.method_5667(), Float.valueOf(saturation));
        }
        float exhaustionLevel = ExhaustionHelper.getExhaustion((class_1657)player);
        if (lastExhaustionLevel == null || Math.abs(lastExhaustionLevel.floatValue() - exhaustionLevel) >= 0.01f) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)new ExhaustionSyncPayload(exhaustionLevel));
            lastExhaustionLevels.put(player.method_5667(), Float.valueOf(exhaustionLevel));
        }
    }

    public static void onPlayerLoggedIn(class_3222 player) {
        lastSaturationLevels.remove(player.method_5667());
        lastExhaustionLevels.remove(player.method_5667());
        if (!naturalRegeneration) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)new NaturalRegenerationSyncPayload(false));
        }
    }

    public static void onServerWorldTick(class_3218 world) {
        boolean cur = world.method_64395().method_8355(class_1928.field_19395);
        if (naturalRegeneration != cur) {
            for (class_3222 player : world.method_18456()) {
                ServerPlayNetworking.send((class_3222)player, (class_8710)new NaturalRegenerationSyncPayload(cur));
            }
            naturalRegeneration = cur;
        }
    }
}

