/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.block;

import java.util.ArrayList;
import java.util.Map;
import juuxel.adorn.block.BlockWithDescription;
import juuxel.adorn.block.SeatBlock;
import juuxel.adorn.lib.AdornStats;
import juuxel.adorn.util.AdornUtil;
import juuxel.adorn.util.Shapes;
import net.minecraft.class_10225;
import net.minecraft.class_1297;
import net.minecraft.class_1750;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2470;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5819;

public final class BenchBlock
extends SeatBlock
implements class_3737,
BlockWithDescription {
    public static final class_2754<class_2350.class_2351> AXIS = class_2741.field_12529;
    public static final class_2746 CONNECTED_N = class_2746.method_11825((String)"connected_n");
    public static final class_2746 CONNECTED_P = class_2746.method_11825((String)"connected_p");
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    private static final String DESCRIPTION_KEY = "block.adorn.bench.description";
    private static final class_265 X_TOP_SHAPE = BenchBlock.method_9541((double)0.0, (double)8.0, (double)1.0, (double)16.0, (double)10.0, (double)15.0);
    private static final class_265 Z_TOP_SHAPE = BenchBlock.method_9541((double)1.0, (double)8.0, (double)0.0, (double)15.0, (double)10.0, (double)16.0);
    private static final class_265[] SHAPES = new class_265[8];

    public BenchBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657(AXIS, (Comparable)class_2350.class_2351.field_11051)).method_11657((class_2769)CONNECTED_N, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)CONNECTED_P, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public class_2680 method_9605(class_1750 ctx) {
        class_2680 state = (class_2680)((class_2680)this.method_9564().method_11657(AXIS, (Comparable)AdornUtil.turnHorizontally(ctx.method_8042().method_10166()))).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(ctx.method_8045().method_8316(ctx.method_8037()).method_15772() == class_3612.field_15910));
        return this.updateConnections((class_1922)ctx.method_8045(), ctx.method_8037(), state);
    }

    protected class_2680 method_9559(class_2680 state, class_4538 world, class_10225 tickView, class_2338 pos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        if (((Boolean)state.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            tickView.method_64312(pos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789(world));
        }
        return this.updateConnections((class_1922)world, pos, state);
    }

    private class_2680 updateConnections(class_1922 world, class_2338 pos, class_2680 state) {
        for (class_2350.class_2352 axisDirection : class_2350.class_2352.values()) {
            class_2746 property = axisDirection == class_2350.class_2352.field_11060 ? CONNECTED_N : CONNECTED_P;
            class_2680 neighbor = world.method_8320(pos.method_30513((class_2350.class_2351)state.method_11654(AXIS), axisDirection.method_10181()));
            boolean connected = neighbor.method_26204() instanceof BenchBlock && neighbor.method_11654(AXIS) == state.method_11654(AXIS);
            state = (class_2680)state.method_11657((class_2769)property, (Comparable)Boolean.valueOf(connected));
        }
        return state;
    }

    public class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPES[BenchBlock.getShapeKey((class_2350.class_2351)state.method_11654(AXIS), (Boolean)state.method_11654((class_2769)CONNECTED_N), (Boolean)state.method_11654((class_2769)CONNECTED_P))];
    }

    private static int getShapeKey(class_2350.class_2351 axis, boolean connectedN, boolean connectedP) {
        return (axis == class_2350.class_2351.field_11048 ? 1 : 0) << 2 | (connectedN ? 1 : 0) << 1 | (connectedP ? 1 : 0);
    }

    public class_3610 method_9545(class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{AXIS, CONNECTED_N, CONNECTED_P, WATERLOGGED});
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return switch (rotation) {
            case class_2470.field_11465, class_2470.field_11463 -> (class_2680)state.method_11657(AXIS, (Comparable)AdornUtil.turnHorizontally((class_2350.class_2351)state.method_11654(AXIS)));
            default -> state;
        };
    }

    @Override
    public class_2960 getSittingStat() {
        return AdornStats.SIT_ON_BENCH;
    }

    @Override
    public String getDescriptionKey() {
        return DESCRIPTION_KEY;
    }

    @Override
    public class_2350 getPreferredDismountDirection(class_2680 state, class_1297 passenger) {
        class_2350.class_2351 axis = AdornUtil.turnHorizontally((class_2350.class_2351)state.method_11654(AXIS));
        class_2350 passengerFacing = passenger.method_5735();
        return passengerFacing.method_10166() == axis ? passengerFacing : class_2350.method_10156((class_2350.class_2352)class_2350.class_2352.field_11056, (class_2350.class_2351)axis);
    }

    static {
        Map<class_2350, class_265> legShapes = Shapes.buildShapeRotationsFromNorth(2, 0, 2, 14, 8, 4);
        boolean[] booleans = new boolean[]{true, false};
        for (class_2350.class_2351 axis : new class_2350.class_2351[]{class_2350.class_2351.field_11048, class_2350.class_2351.field_11051}) {
            class_265 topShape = axis == class_2350.class_2351.field_11048 ? X_TOP_SHAPE : Z_TOP_SHAPE;
            class_265 negativeLeg = legShapes.get(class_2350.method_10169((class_2350.class_2351)axis, (class_2350.class_2352)class_2350.class_2352.field_11060));
            class_265 positiveLeg = legShapes.get(class_2350.method_10169((class_2350.class_2351)axis, (class_2350.class_2352)class_2350.class_2352.field_11056));
            for (boolean connectedN : booleans) {
                for (boolean connectedP : booleans) {
                    ArrayList<class_265> parts = new ArrayList<class_265>();
                    if (!connectedN) {
                        parts.add(negativeLeg);
                    }
                    if (!connectedP) {
                        parts.add(positiveLeg);
                    }
                    int key = BenchBlock.getShapeKey(axis, connectedN, connectedP);
                    BenchBlock.SHAPES[key] = class_259.method_17786((class_265)topShape, (class_265[])((class_265[])parts.toArray(class_265[]::new)));
                }
            }
        }
    }
}

