/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.block.entity;

import juuxel.adorn.block.AdornBlockEntities;
import juuxel.adorn.block.BrewerBlock;
import juuxel.adorn.block.entity.BaseContainerBlockEntity;
import juuxel.adorn.fluid.FluidReference;
import juuxel.adorn.item.AdornItems;
import juuxel.adorn.menu.BrewerMenu;
import juuxel.adorn.platform.ItemBridge;
import juuxel.adorn.recipe.AdornRecipeTypes;
import juuxel.adorn.recipe.BrewerInput;
import juuxel.adorn.recipe.BrewingRecipe;
import juuxel.adorn.recipe.FluidBrewingRecipe;
import juuxel.adorn.recipe.InventoryWrappingRecipeInput;
import net.minecraft.class_1263;
import net.minecraft.class_1264;
import net.minecraft.class_1278;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3913;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import org.jetbrains.annotations.Nullable;

public abstract class BrewerBlockEntity
extends BaseContainerBlockEntity
implements class_1278 {
    private static final String NBT_PROGRESS = "Progress";
    public static final int CONTAINER_SIZE = 4;
    public static final int INPUT_SLOT = 0;
    public static final int LEFT_INGREDIENT_SLOT = 1;
    public static final int RIGHT_INGREDIENT_SLOT = 2;
    public static final int FLUID_CONTAINER_SLOT = 3;
    public static final int MAX_PROGRESS = 200;
    public static final int FLUID_CAPACITY_IN_BUCKETS = 2;
    private int progress = 0;
    private final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            switch (index) {
                case 0: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown property: " + index);
                }
            }
            return BrewerBlockEntity.this.progress;
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    BrewerBlockEntity.this.progress = value;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown property: " + index);
                }
            }
        }

        public int method_17389() {
            return 1;
        }
    };

    public BrewerBlockEntity(class_2338 pos, class_2680 state) {
        super((class_2591)AdornBlockEntities.BREWER.get(), pos, state, 4);
    }

    protected class_1703 method_5465(int syncId, class_1661 inv) {
        return new BrewerMenu(syncId, inv, (class_1263)this, this.propertyDelegate, this.getFluidReference());
    }

    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registries) {
        super.method_11007(nbt, registries);
        nbt.method_10569(NBT_PROGRESS, this.progress);
    }

    @Override
    public void method_11014(class_2487 nbt, class_7225.class_7874 registries) {
        super.method_11014(nbt, registries);
        this.progress = nbt.method_68083(NBT_PROGRESS, 0);
    }

    public int[] method_5494(class_2350 side) {
        class_2350 facing = (class_2350)this.method_11010().method_11654(BrewerBlock.FACING);
        if (side == facing.method_10170()) {
            return new int[]{1};
        }
        if (side == facing.method_10160()) {
            return new int[]{2};
        }
        if (side == facing.method_10153()) {
            return new int[]{3};
        }
        if (side == class_2350.field_11036) {
            return new int[]{0};
        }
        if (side == class_2350.field_11033) {
            return new int[]{0, 3};
        }
        return new int[0];
    }

    public boolean method_5437(int slot, class_1799 stack) {
        if (!(slot != 0 || stack.method_31574((class_1792)AdornItems.MUG.get()) && this.method_5438(slot).method_7960())) {
            return false;
        }
        return slot != 3 || this.method_5438(slot).method_7960();
    }

    public boolean method_5492(int slot, class_1799 stack, @Nullable class_2350 dir) {
        return dir != class_2350.field_11033 && this.method_5437(slot, stack);
    }

    public boolean method_5493(int slot, class_1799 stack, class_2350 dir) {
        return dir == class_2350.field_11033 && (slot != 3 || this.canExtractFluidContainer());
    }

    public int calculateComparatorOutput() {
        class_1799 mugStack = this.method_5438(0);
        if (!mugStack.method_7960() && !mugStack.method_31574((class_1792)AdornItems.MUG.get())) {
            return 15;
        }
        float progressFraction = (float)this.progress / 200.0f;
        float level = progressFraction * 14.0f;
        return class_3532.method_15386((float)level);
    }

    public abstract FluidReference getFluidReference();

    protected abstract boolean canExtractFluidContainer();

    protected abstract void tryExtractFluidContainer();

    private boolean isActive() {
        return this.progress != 0;
    }

    private static void decrementIngredient(BrewerBlockEntity brewer, int slot) {
        class_1799 stack = brewer.method_5438(slot);
        class_1799 remainder = ItemBridge.get().getRecipeRemainder(stack);
        stack.method_7934(1);
        if (!remainder.method_7960()) {
            if (stack.method_7960()) {
                brewer.method_5447(slot, remainder);
            } else {
                class_1264.method_5449((class_1937)brewer.field_11863, (double)((double)brewer.field_11867.method_10263() + 0.5), (double)((double)brewer.field_11867.method_10264() + 0.5), (double)((double)brewer.field_11867.method_10260() + 0.5), (class_1799)remainder);
            }
        }
    }

    public static void tick(class_3218 world, class_2338 pos, class_2680 state, BrewerBlockEntity brewer) {
        boolean hasMug;
        boolean originallyActive = brewer.isActive();
        brewer.tryExtractFluidContainer();
        boolean dirty = false;
        boolean bl = hasMug = !brewer.method_5438(0).method_7960();
        if (hasMug != (Boolean)state.method_11654((class_2769)BrewerBlock.HAS_MUG)) {
            world.method_8501(pos, (class_2680)state.method_11657((class_2769)BrewerBlock.HAS_MUG, (Comparable)Boolean.valueOf(hasMug)));
        }
        RecipeInputImpl input = new RecipeInputImpl(brewer);
        BrewingRecipe recipe = world.method_64577().method_8132((class_3956)AdornRecipeTypes.BREWING.get(), (class_9695)input, (class_1937)world).map(class_8786::comp_1933).orElse(null);
        if (recipe != null && brewer.method_5438(0).method_31574((class_1792)AdornItems.MUG.get())) {
            if (brewer.progress++ >= 200) {
                BrewerBlockEntity.decrementIngredient(brewer, 1);
                BrewerBlockEntity.decrementIngredient(brewer, 2);
                brewer.method_5447(0, recipe.method_8116(input, (class_7225.class_7874)world.method_30349()));
                if (recipe instanceof FluidBrewingRecipe) {
                    FluidBrewingRecipe fluidRecipe = (FluidBrewingRecipe)recipe;
                    brewer.getFluidReference().decrement(fluidRecipe.fluid().amount(), fluidRecipe.fluid().unit());
                }
            }
            dirty = true;
        } else if (brewer.progress != 0) {
            brewer.progress = 0;
            dirty = true;
        }
        boolean activeNow = brewer.isActive();
        if (originallyActive != activeNow) {
            dirty = true;
            class_2680 newState = (class_2680)state.method_11657((class_2769)BrewerBlock.ACTIVE, (Comparable)Boolean.valueOf(activeNow));
            world.method_8501(pos, newState);
        }
        if (dirty) {
            BrewerBlockEntity.method_31663((class_1937)world, (class_2338)pos, (class_2680)state);
        }
    }

    private static final class RecipeInputImpl
    extends InventoryWrappingRecipeInput<BrewerBlockEntity>
    implements BrewerInput {
        private RecipeInputImpl(BrewerBlockEntity brewer) {
            super(brewer);
        }

        @Override
        public FluidReference getFluidReference() {
            return ((BrewerBlockEntity)this.parent).getFluidReference();
        }
    }
}

