/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.block.property;

import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.lang.runtime.SwitchBootstraps;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3542;
import org.jetbrains.annotations.Nullable;

public final class OptionalProperty<T extends Enum<T>>
extends class_2769<Value<T>> {
    private static final String NONE_NAME = "none";
    private final class_2754<T> delegate;
    private final Value.None<T> none = new Value.None();
    private final Map<@Nullable T, Value<T>> values;
    private final List<Value<T>> boxedValues;

    public OptionalProperty(class_2754<T> delegate) {
        super(delegate.method_11899(), Value.class);
        this.delegate = delegate;
        this.values = new LinkedHashMap<T, Value<T>>();
        this.values.put(null, this.none);
        for (Enum value : delegate.method_11898()) {
            if (NONE_NAME.equals(((class_3542)value).method_15434())) {
                throw new IllegalArgumentException("Delegate has a 'none' value");
            }
            this.values.put(value, new Value.Some<Enum>(value));
        }
        this.boxedValues = List.copyOf(this.values.values());
    }

    public Optional<Value<T>> method_11900(String name) {
        return NONE_NAME.equals(name) ? Optional.of(this.none) : this.delegate.method_11900(name).map(x$0 -> (Value)this.values.get(x$0));
    }

    public List<Value<T>> method_11898() {
        return this.boxedValues;
    }

    public int ordinal(Value<T> value) {
        return this.boxedValues.indexOf(value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String name(Value<T> value) {
        Object inner;
        if (!(value instanceof Value.Some)) return NONE_NAME;
        Value.Some some = (Value.Some)value;
        try {
            Object object;
            inner = object = some.value();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        String string = ((class_3542)inner).method_15434();
        return string;
    }

    public class_2754<T> getDelegate() {
        return this.delegate;
    }

    public Value.None<T> getNone() {
        return this.none;
    }

    @Nullable
    public Value<T> wrap(@Nullable T value) {
        return this.values.get(value);
    }

    public Value<T> wrapOrNone(@Nullable T value) {
        return this.values.getOrDefault(value, this.none);
    }

    public static sealed interface Value<T>
    extends Comparable<Value<T>> {
        public boolean isPresent();

        @Nullable
        public T value();

        public static final class None<T extends Enum<T>>
        implements Value<T> {
            @Override
            @Nullable
            public T value() {
                return null;
            }

            @Override
            public boolean isPresent() {
                return false;
            }

            @Override
            public int compareTo(Value<T> o) {
                return o instanceof None ? 0 : -1;
            }

            public int hashCode() {
                return 0;
            }

            public boolean equals(Object obj) {
                return obj instanceof None;
            }
        }

        public static final class Some<T extends Enum<T>>
        extends Record
        implements Value<T> {
            private final T value;

            public Some(T value) {
                this.value = value;
            }

            @Override
            public boolean isPresent() {
                return true;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public int compareTo(Value<T> o) {
                Value<T> value = o;
                Objects.requireNonNull(value);
                Value<T> value2 = value;
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Some.class, None.class}, value2, n)) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        Some some = (Some)value2;
                        try {
                            Object object;
                            Object otherValue = object = some.value();
                            int n2 = ((Enum)this.value).compareTo((Object)otherValue);
                            return n2;
                        }
                        catch (Throwable throwable) {
                            throw new MatchException(throwable.toString(), throwable);
                        }
                    }
                    case 1: 
                }
                None none = (None)value2;
                return 1;
            }

            @Override
            public final String toString() {
                return ObjectMethods.bootstrap("toString", new MethodHandle[]{Some.class, "value", "value"}, this);
            }

            @Override
            public final int hashCode() {
                return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{Some.class, "value", "value"}, this);
            }

            @Override
            public final boolean equals(Object o) {
                return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{Some.class, "value", "value"}, this, o);
            }

            @Override
            public T value() {
                return this.value;
            }
        }
    }
}

