/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.fluid;

import com.mojang.serialization.Codec;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import juuxel.adorn.fluid.HasFluidAmount;
import juuxel.adorn.util.Displayable;
import juuxel.adorn.util.MixedFraction;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public enum FluidUnit implements Displayable
{
    LITRE("litres", 1000L),
    DROPLET("droplets", 81000L);

    public static final Codec<FluidUnit> CODEC;
    private static final Map<String, FluidUnit> BY_ID;
    private final String id;
    private final long bucketVolume;
    private final class_2561 displayName;
    private final class_2561 symbol;

    private FluidUnit(String id, long bucketVolume) {
        this.id = id;
        this.bucketVolume = bucketVolume;
        this.displayName = class_2561.method_43471((String)"gui.adorn.fluid_unit.%s.name".formatted(id));
        this.symbol = class_2561.method_43471((String)"gui.adorn.fluid_unit.%s.symbol".formatted(id));
    }

    public String getId() {
        return this.id;
    }

    public long getBucketVolume() {
        return this.bucketVolume;
    }

    @Override
    public class_2561 getDisplayName() {
        return this.displayName;
    }

    public class_2561 getSymbol() {
        return this.symbol;
    }

    @Nullable
    public static FluidUnit byId(String id) {
        return BY_ID.get(id.toLowerCase(Locale.ROOT));
    }

    public static long convert(long volume, FluidUnit from, FluidUnit to) {
        if (from == to) {
            return volume;
        }
        return volume * to.getBucketVolume() / from.getBucketVolume();
    }

    public static MixedFraction losslessConvert(long volume, FluidUnit from, FluidUnit to) {
        if (from == to) {
            return MixedFraction.whole(volume);
        }
        return MixedFraction.of(volume * to.getBucketVolume(), from.getBucketVolume());
    }

    public static double convertAsDouble(double volume, FluidUnit from, FluidUnit to) {
        if (from == to) {
            return volume;
        }
        return volume * (double)to.getBucketVolume() / (double)from.getBucketVolume();
    }

    public static int compareVolumes(long volume1, FluidUnit unit1, long volume2, FluidUnit unit2) {
        if (unit1 == unit2) {
            return Long.compare(volume1, volume2);
        }
        if (unit1.getBucketVolume() > unit2.getBucketVolume()) {
            return Long.compare(volume1, volume2 * unit1.getBucketVolume() / unit2.getBucketVolume());
        }
        return Long.compare(volume1 * unit2.getBucketVolume() / unit1.getBucketVolume(), volume2);
    }

    public static int compareVolumes(HasFluidAmount volume1, HasFluidAmount volume2) {
        return FluidUnit.compareVolumes(volume1.getAmount(), volume1.getUnit(), volume2.getAmount(), volume2.getUnit());
    }

    static {
        CODEC = Codec.STRING.xmap(FluidUnit::byId, FluidUnit::getId);
        BY_ID = Arrays.stream(FluidUnit.values()).collect(Collectors.toMap(FluidUnit::getId, Function.identity()));
    }
}

