/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.lib.registry;

import com.google.common.base.Suppliers;
import java.util.Collections;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Stream;
import juuxel.adorn.lib.registry.Registered;

public final class RegisteredMap<K, V>
implements Registered<Map<K, V>> {
    private final Map<K, Registered<? extends V>> map;
    private final Supplier<Map<K, V>> builtMap;

    private RegisteredMap(MapFactory<K> mapFactory, Map<K, Registered<? extends V>> map) {
        this.map = map;
        this.builtMap = Suppliers.memoize(() -> {
            Map result = mapFactory.create();
            this.map.forEach((key, value) -> result.put(key, value.get()));
            return Collections.unmodifiableMap(result);
        });
    }

    public Registered<? extends V> get(K key) {
        return this.map.get(key);
    }

    public V getEager(K key) {
        return (V)this.get(key).get();
    }

    @Override
    public Map<K, V> get() {
        return this.builtMap.get();
    }

    public Stream<V> values() {
        return this.map.values().stream().map(Supplier::get);
    }

    public void forEach(BiConsumer<? super K, ? super V> action) {
        this.map.forEach((key, value) -> action.accept((Object)key, (Object)value.get()));
    }

    public static <K, V> Builder<K, V> builder(MapFactory<K> mapFactory) {
        return new Builder(mapFactory, mapFactory.create());
    }

    @FunctionalInterface
    public static interface MapFactory<K> {
        public <V> Map<K, V> create();

        public static <K extends Enum<K>> MapFactory<K> enumKeys(final Class<K> keyClass) {
            return new MapFactory<K>(){

                @Override
                public <V> Map<K, V> create() {
                    return new EnumMap(keyClass);
                }
            };
        }

        public static <K> MapFactory<K> linkedHashKeys() {
            return LinkedHashMap::new;
        }
    }

    public static final class Builder<K, V> {
        private final MapFactory<K> mapFactory;
        private final Map<K, Registered<? extends V>> backing;

        private Builder(MapFactory<K> mapFactory, Map<K, Registered<? extends V>> backing) {
            this.mapFactory = mapFactory;
            this.backing = backing;
        }

        public Builder<K, V> put(K key, Registered<? extends V> value) {
            this.backing.put(key, value);
            return this;
        }

        public RegisteredMap<K, V> build() {
            return new RegisteredMap<K, V>(this.mapFactory, this.backing);
        }
    }
}

