/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.util;

import java.util.ArrayList;
import java.util.List;
import juuxel.adorn.util.CollectionUtil;
import juuxel.adorn.util.NbtConvertible;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_7225;
import net.minecraft.class_9288;
import org.jetbrains.annotations.Nullable;

public class InventoryComponent
implements class_1263,
NbtConvertible {
    private final int size;
    private final List<class_1265> listeners = new ArrayList<class_1265>();
    private final class_2371<class_1799> items;

    public InventoryComponent(int size) {
        this.size = size;
        this.items = class_2371.method_10213((int)size, (Object)class_1799.field_8037);
    }

    private InventoryComponent(class_2371<class_1799> items) {
        this(items.size());
        for (int i = 0; i < items.size(); ++i) {
            this.items.set(i, (Object)((class_1799)items.get(i)));
        }
    }

    public InventoryComponent copy() {
        return new InventoryComponent(this.items);
    }

    public boolean canExtract(class_1799 stack) {
        int remainingAmount = stack.method_7947();
        for (class_1799 invStack : this.items) {
            if (!class_1799.method_7984((class_1799)invStack, (class_1799)stack) || (remainingAmount -= invStack.method_7947()) > 0) continue;
            return true;
        }
        return false;
    }

    public boolean tryExtract(class_1799 stack) {
        int remainingAmount = stack.method_7947();
        for (class_1799 invStack : this.items) {
            if (!class_1799.method_31577((class_1799)invStack, (class_1799)stack)) continue;
            int invStackAmount = invStack.method_7947();
            invStack.method_7934(Math.min(invStackAmount, remainingAmount));
            if ((remainingAmount -= invStackAmount) > 0) continue;
            return true;
        }
        return false;
    }

    public boolean canInsert(class_1799 stack) {
        int remainingAmount = stack.method_7947();
        for (class_1799 invStack : this.items) {
            int insertionAmount;
            if (!(class_1799.method_31577((class_1799)invStack, (class_1799)stack) && invStack.method_7947() < invStack.method_7914() ? (remainingAmount -= (insertionAmount = Math.min(invStack.method_7914() - invStack.method_7947(), remainingAmount))) <= 0 : invStack.method_7960())) continue;
            return true;
        }
        return false;
    }

    public boolean tryInsert(class_1799 stack) {
        int remainingAmount = stack.method_7947();
        for (int slot = 0; slot < this.items.size(); ++slot) {
            class_1799 invStack = (class_1799)this.items.get(slot);
            if (class_1799.method_31577((class_1799)invStack, (class_1799)stack) && invStack.method_7947() < invStack.method_7914()) {
                int insertionAmount = Math.min(invStack.method_7914() - invStack.method_7947(), remainingAmount);
                invStack.method_7933(insertionAmount);
                if ((remainingAmount -= insertionAmount) > 0) continue;
                return true;
            }
            if (!invStack.method_7960()) continue;
            this.items.set(slot, (Object)stack.method_7972());
            return true;
        }
        return false;
    }

    public int getCountWithComponents(class_1799 stack) {
        return CollectionUtil.sumOf(this.items, it -> class_1799.method_31577((class_1799)stack, (class_1799)it) ? it.method_7947() : 0);
    }

    @Override
    public class_2487 writeNbt(class_2487 nbt, class_7225.class_7874 registries) {
        class_1262.method_5426((class_2487)nbt, this.items, (class_7225.class_7874)registries);
        return nbt;
    }

    @Override
    public void readNbt(class_2487 nbt, class_7225.class_7874 registries) {
        class_1262.method_5429((class_2487)nbt, this.items, (class_7225.class_7874)registries);
    }

    public class_9288 toContainerComponent() {
        return class_9288.method_57493(this.items);
    }

    public void copyFrom(@Nullable class_9288 component) {
        if (component == null) {
            return;
        }
        component.method_57492(this.items);
    }

    public class_1799 method_5438(int slot) {
        return (class_1799)this.items.get(slot);
    }

    public void method_5448() {
        this.items.clear();
        this.method_5431();
    }

    public void method_5447(int slot, class_1799 stack) {
        this.items.set(slot, (Object)stack);
    }

    public class_1799 method_5441(int slot) {
        return class_1262.method_5428(this.items, (int)slot);
    }

    public boolean method_5443(class_1657 player) {
        return true;
    }

    public int method_5439() {
        return this.size;
    }

    public class_1799 method_5434(int slot, int count) {
        class_1799 stack = class_1262.method_5430(this.items, (int)slot, (int)count);
        if (!stack.method_7960()) {
            this.method_5431();
        }
        return stack;
    }

    public boolean method_5442() {
        for (class_1799 stack : this.items) {
            if (stack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public void method_5431() {
        for (class_1265 listener : this.listeners) {
            listener.method_5453((class_1263)this);
        }
    }

    public void addListener(class_1265 listener) {
        this.listeners.add(listener);
    }
}

