/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.util.animation;

import java.util.function.Consumer;
import java.util.function.Supplier;
import juuxel.adorn.util.animation.AbstractAnimatedProperty;
import juuxel.adorn.util.animation.AnimationEngine;
import juuxel.adorn.util.animation.Interpolator;

public final class AnimatedPropertyWrapper<T>
extends AbstractAnimatedProperty<T> {
    private final Supplier<T> getter;
    private final Consumer<T> setter;

    public AnimatedPropertyWrapper(AnimationEngine engine, int duration, Interpolator<T> interpolator, Supplier<T> getter, Consumer<T> setter) {
        super(engine, duration, interpolator);
        this.getter = getter;
        this.setter = setter;
    }

    @Override
    public T get() {
        return this.getter.get();
    }

    @Override
    protected void setRawValue(T value) {
        this.setter.accept(value);
    }
}

