/*
 * Decompiled with CFR 0.152.
 */
package DistantHorizons.libraries.lwjgl.system.jawt;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct JAWT_Rectangle")
public class JAWTRectangle
extends Struct<JAWTRectangle>
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;
    public static final int WIDTH;
    public static final int HEIGHT;

    protected JAWTRectangle(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    protected JAWTRectangle create(long address, @Nullable ByteBuffer container) {
        return new JAWTRectangle(address, container);
    }

    public JAWTRectangle(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), JAWTRectangle.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="jint")
    public int x() {
        return JAWTRectangle.nx(this.address());
    }

    @NativeType(value="jint")
    public int y() {
        return JAWTRectangle.ny(this.address());
    }

    @NativeType(value="jint")
    public int width() {
        return JAWTRectangle.nwidth(this.address());
    }

    @NativeType(value="jint")
    public int height() {
        return JAWTRectangle.nheight(this.address());
    }

    public JAWTRectangle x(@NativeType(value="jint") int value) {
        JAWTRectangle.nx(this.address(), value);
        return this;
    }

    public JAWTRectangle y(@NativeType(value="jint") int value) {
        JAWTRectangle.ny(this.address(), value);
        return this;
    }

    public JAWTRectangle width(@NativeType(value="jint") int value) {
        JAWTRectangle.nwidth(this.address(), value);
        return this;
    }

    public JAWTRectangle height(@NativeType(value="jint") int value) {
        JAWTRectangle.nheight(this.address(), value);
        return this;
    }

    public JAWTRectangle set(int x, int y, int width, int height) {
        this.x(x);
        this.y(y);
        this.width(width);
        this.height(height);
        return this;
    }

    public JAWTRectangle set(JAWTRectangle src) {
        MemoryUtil.memCopy((long)src.address(), (long)this.address(), (long)SIZEOF);
        return this;
    }

    public static JAWTRectangle malloc() {
        return new JAWTRectangle(MemoryUtil.nmemAllocChecked((long)SIZEOF), null);
    }

    public static JAWTRectangle calloc() {
        return new JAWTRectangle(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF), null);
    }

    public static JAWTRectangle create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return new JAWTRectangle(MemoryUtil.memAddress((ByteBuffer)container), container);
    }

    public static JAWTRectangle create(long address) {
        return new JAWTRectangle(address, null);
    }

    @Nullable
    public static JAWTRectangle createSafe(long address) {
        return address == 0L ? null : new JAWTRectangle(address, null);
    }

    public static Buffer malloc(int capacity) {
        return new Buffer(MemoryUtil.nmemAllocChecked((long)JAWTRectangle.__checkMalloc((int)capacity, (int)SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return new Buffer(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = JAWTRectangle.__create((int)capacity, (int)SIZEOF);
        return new Buffer(MemoryUtil.memAddress((ByteBuffer)container), container, -1, 0, capacity, capacity);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : new Buffer(address, capacity);
    }

    @Deprecated
    public static JAWTRectangle mallocStack() {
        return JAWTRectangle.malloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static JAWTRectangle callocStack() {
        return JAWTRectangle.calloc(MemoryStack.stackGet());
    }

    @Deprecated
    public static JAWTRectangle mallocStack(MemoryStack stack) {
        return JAWTRectangle.malloc(stack);
    }

    @Deprecated
    public static JAWTRectangle callocStack(MemoryStack stack) {
        return JAWTRectangle.calloc(stack);
    }

    @Deprecated
    public static Buffer mallocStack(int capacity) {
        return JAWTRectangle.malloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer callocStack(int capacity) {
        return JAWTRectangle.calloc(capacity, MemoryStack.stackGet());
    }

    @Deprecated
    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return JAWTRectangle.malloc(capacity, stack);
    }

    @Deprecated
    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return JAWTRectangle.calloc(capacity, stack);
    }

    public static JAWTRectangle malloc(MemoryStack stack) {
        return new JAWTRectangle(stack.nmalloc(ALIGNOF, SIZEOF), null);
    }

    public static JAWTRectangle calloc(MemoryStack stack) {
        return new JAWTRectangle(stack.ncalloc(ALIGNOF, 1, SIZEOF), null);
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return new Buffer(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nx(long struct) {
        return UNSAFE.getInt(null, struct + (long)X);
    }

    public static int ny(long struct) {
        return UNSAFE.getInt(null, struct + (long)Y);
    }

    public static int nwidth(long struct) {
        return UNSAFE.getInt(null, struct + (long)WIDTH);
    }

    public static int nheight(long struct) {
        return UNSAFE.getInt(null, struct + (long)HEIGHT);
    }

    public static void nx(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)X, value);
    }

    public static void ny(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)Y, value);
    }

    public static void nwidth(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)WIDTH, value);
    }

    public static void nheight(long struct, int value) {
        UNSAFE.putInt(null, struct + (long)HEIGHT, value);
    }

    static {
        Struct.Layout layout = JAWTRectangle.__struct((Struct.Member[])new Struct.Member[]{JAWTRectangle.__member((int)4), JAWTRectangle.__member((int)4), JAWTRectangle.__member((int)4), JAWTRectangle.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
        WIDTH = layout.offsetof(2);
        HEIGHT = layout.offsetof(3);
    }

    public static class Buffer
    extends StructBuffer<JAWTRectangle, Buffer>
    implements NativeResource {
        private static final JAWTRectangle ELEMENT_FACTORY = JAWTRectangle.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected JAWTRectangle getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="jint")
        public int x() {
            return JAWTRectangle.nx(this.address());
        }

        @NativeType(value="jint")
        public int y() {
            return JAWTRectangle.ny(this.address());
        }

        @NativeType(value="jint")
        public int width() {
            return JAWTRectangle.nwidth(this.address());
        }

        @NativeType(value="jint")
        public int height() {
            return JAWTRectangle.nheight(this.address());
        }

        public Buffer x(@NativeType(value="jint") int value) {
            JAWTRectangle.nx(this.address(), value);
            return this;
        }

        public Buffer y(@NativeType(value="jint") int value) {
            JAWTRectangle.ny(this.address(), value);
            return this;
        }

        public Buffer width(@NativeType(value="jint") int value) {
            JAWTRectangle.nwidth(this.address(), value);
            return this;
        }

        public Buffer height(@NativeType(value="jint") int value) {
            JAWTRectangle.nheight(this.address(), value);
            return this;
        }
    }
}

