/*
 * Decompiled with CFR 0.152.
 */
package net.caffeinemc.mods.sodium.client.render.frapi.render;

import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import net.caffeinemc.mods.sodium.api.texture.SpriteUtil;
import net.caffeinemc.mods.sodium.api.util.ColorMixer;
import net.caffeinemc.mods.sodium.client.render.frapi.SodiumRenderer;
import net.caffeinemc.mods.sodium.client.render.frapi.helper.ColorHelper;
import net.caffeinemc.mods.sodium.client.render.frapi.material.RenderMaterialImpl;
import net.caffeinemc.mods.sodium.client.render.frapi.mesh.EncodingFormat;
import net.caffeinemc.mods.sodium.client.render.frapi.mesh.MeshViewImpl;
import net.caffeinemc.mods.sodium.client.render.frapi.mesh.MutableQuadViewImpl;
import net.caffeinemc.mods.sodium.client.render.frapi.render.AbstractRenderContext;
import net.caffeinemc.mods.sodium.client.render.frapi.render.QuadEncoder;
import net.caffeinemc.mods.sodium.client.render.texture.SpriteFinderCache;
import net.caffeinemc.mods.sodium.mixin.features.render.frapi.ItemRendererAccessor;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.api.renderer.v1.material.GlintMode;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.minecraft.class_10444;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1921;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4722;
import net.minecraft.class_5819;
import net.minecraft.class_6575;
import net.minecraft.class_777;
import net.minecraft.class_7837;
import net.minecraft.class_811;
import net.minecraft.class_918;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class ItemRenderContext
extends AbstractRenderContext {
    public static final ThreadLocal<ItemRenderContext> POOL = ThreadLocal.withInitial(ItemRenderContext::new);
    private static final long ITEM_RANDOM_SEED = 42L;
    private static final int GLINT_COUNT = class_10444.class_10445.values().length;
    private final MutableQuadViewImpl editorQuad = new ItemEmitter();
    private final class_5819 random = new class_6575(42L);
    private final Supplier<class_5819> randomSupplier = () -> {
        this.random.method_43052(42L);
        return this.random;
    };
    private class_811 transformMode;
    private class_4587 poseStack;
    private Matrix4f matPosition;
    private boolean trustedNormals;
    private Matrix3f matNormal;
    private class_4597 bufferSource;
    private int lightmap;
    private int overlay;
    private int[] colors;
    private class_1921 defaultLayer;
    private class_10444.class_10445 defaultGlint;
    private class_4587.class_4665 specialGlintEntry;
    private final class_4588[] vertexConsumerCache = new class_4588[3 * GLINT_COUNT];

    @Override
    public QuadEmitter getEmitter() {
        this.editorQuad.clear();
        return this.editorQuad;
    }

    public void renderItem(class_811 displayContext, class_4587 poseStack, class_4597 bufferSource, int lightmap, int overlay, int[] colors, List<class_777> vanillaQuads, MeshViewImpl mesh, class_1921 layer, class_10444.class_10445 glint) {
        this.transformMode = displayContext;
        this.matPosition = poseStack.method_23760().method_23761();
        this.poseStack = poseStack;
        this.trustedNormals = this.poseStack.method_23760().field_48930;
        this.matNormal = this.poseStack.method_23760().method_23762();
        this.bufferSource = bufferSource;
        this.lightmap = lightmap;
        this.overlay = overlay;
        this.colors = colors;
        this.defaultLayer = layer;
        this.defaultGlint = glint;
        this.bufferQuads(vanillaQuads, mesh);
        this.poseStack = null;
        this.bufferSource = null;
        this.colors = null;
        this.specialGlintEntry = null;
        Arrays.fill(this.vertexConsumerCache, null);
    }

    private void bufferQuads(List<class_777> vanillaQuads, MeshViewImpl mesh) {
        QuadEmitter emitter = this.getEmitter();
        int vanillaQuadCount = vanillaQuads.size();
        for (int j = 0; j < vanillaQuadCount; ++j) {
            class_777 q = vanillaQuads.get(j);
            emitter.fromVanilla(q, SodiumRenderer.STANDARD_MATERIAL, null);
            emitter.emit();
        }
        mesh.outputTo(emitter);
    }

    private void renderQuad(MutableQuadViewImpl quad) {
        RenderMaterialImpl mat = quad.material();
        boolean emissive = mat.emissive();
        class_4588 vertexConsumer = this.getVertexConsumer(mat.blendMode(), mat.glintMode());
        this.tintQuad(quad);
        this.shadeQuad(quad, emissive);
        this.bufferQuad(quad, vertexConsumer);
    }

    private void tintQuad(MutableQuadViewImpl quad) {
        int tintIndex = quad.tintIndex();
        if (tintIndex != -1 && tintIndex < this.colors.length) {
            int color = this.colors[tintIndex];
            for (int i = 0; i < 4; ++i) {
                quad.color(i, ColorMixer.mulComponentWise(color, quad.color(i)));
            }
        }
    }

    private void shadeQuad(MutableQuadViewImpl quad, boolean emissive) {
        if (emissive) {
            for (int i = 0; i < 4; ++i) {
                quad.lightmap(i, 0xF000F0);
            }
        } else {
            int lightmap = this.lightmap;
            for (int i = 0; i < 4; ++i) {
                quad.lightmap(i, ColorHelper.maxBrightness(quad.lightmap(i), lightmap));
            }
        }
    }

    private void bufferQuad(MutableQuadViewImpl quad, class_4588 vertexConsumer) {
        QuadEncoder.writeQuadVertices(quad, vertexConsumer, this.overlay, this.matPosition, this.trustedNormals, this.matNormal);
        class_1058 sprite = quad.sprite(SpriteFinderCache.forBlockAtlas());
        if (sprite != null) {
            SpriteUtil.INSTANCE.markSpriteActive(sprite);
        }
    }

    private class_4588 getVertexConsumer(BlendMode blendMode, GlintMode glintMode) {
        class_1921 type = blendMode == BlendMode.DEFAULT ? this.defaultLayer : (blendMode == BlendMode.TRANSLUCENT ? class_4722.method_29382() : class_4722.method_24074());
        class_10444.class_10445 glint = glintMode == GlintMode.DEFAULT ? this.defaultGlint : glintMode.glint;
        int cacheIndex = type == class_4722.method_29382() ? 0 : (type == class_4722.method_24074() ? GLINT_COUNT : 2 * GLINT_COUNT);
        class_4588 vertexConsumer = this.vertexConsumerCache[cacheIndex += glint.ordinal()];
        if (vertexConsumer == null) {
            this.vertexConsumerCache[cacheIndex] = vertexConsumer = this.createVertexConsumer(type, glint);
        }
        return vertexConsumer;
    }

    private class_4588 createVertexConsumer(class_1921 type, class_10444.class_10445 glint) {
        if (glint == class_10444.class_10445.field_55343) {
            if (this.specialGlintEntry == null) {
                this.specialGlintEntry = this.poseStack.method_23760().method_56822();
                if (this.transformMode == class_811.field_4317) {
                    class_7837.method_46414((Matrix4f)this.specialGlintEntry.method_23761(), (float)0.5f);
                } else if (this.transformMode.method_29998()) {
                    class_7837.method_46414((Matrix4f)this.specialGlintEntry.method_23761(), (float)0.75f);
                }
            }
            return ItemRendererAccessor.sodium$getCompassFoilBuffer(this.bufferSource, type, this.specialGlintEntry);
        }
        return class_918.method_23181((class_4597)this.bufferSource, (class_1921)type, (boolean)true, (glint != class_10444.class_10445.field_55341 ? 1 : 0) != 0);
    }

    public class ItemEmitter
    extends MutableQuadViewImpl {
        public ItemEmitter() {
            this.data = new int[EncodingFormat.TOTAL_STRIDE];
            this.clear();
        }

        @Override
        public void emitDirectly() {
            ItemRenderContext.this.renderQuad(this);
        }

        public boolean hasTransforms() {
            return this.activeTransform != NO_TRANSFORM;
        }
    }

    @FunctionalInterface
    public static interface VanillaModelBufferer {
        public void accept(class_1087 var1, int[] var2, int var3, int var4, class_4587 var5, class_4588 var6);
    }
}

