function easeOutBack(t, back, speed)
    back = back or 1.70158
    speed = speed or 1.0
    t = math.min(math.max(t * speed, 0), 1)
    t = t - 1
    return (t * t * ((back + 1) * t + back) + 1)
end

function easeCustom(t)
    local t2 = t * t
    local t3 = t2 * t
    return 3 * t * (1 - t) * (1 - t) * 0.44 +
            3 * t2 * (1 - t) * 1 +
            t3
end

function easeCustomSec(t)
	local t2 = t * t
	local t3 = t2 * t
	return 3 * t * (1 - t) * (1 - t) * 0.44 +
		3 * t2 * (1 - t) * 0.94 +
		t3
end

-- cancel punch for some items

local bl = context.bl
local item = context.item
local matrices = context.matrices
local player = context.player
local mainHand = context.mainHand
local deltaTime = context.deltaTime
local mainHandSwingProgress = context.mainHandSwingProgress
local swingMHand = context.swingMHand
local swingOHand = context.swingOHand
local swingProgress = context.swingProgress
local equipProgress = context.equipProgress
local mainHandSwitchEvent = context.mainHandSwitchEvent
local offHandSwitchEvent = context.offHandSwitchEvent

local l = (bl and 1) or -1
global.customMainSwing = 0.0;
global.customOffSwing = 0.0;
local customSwing = (mainHand and customMainSwing) or customOffSwing
local item = context.item
local matrices = context.matrices
local player = context.player
local particles = context.particles

global.GHP_disablePlanting = 0.0;
global.GHP_prevDisablePlanting = 0.0;
global.GHP_disableThrowing = 0.0;
global.GHP_prevDisableThrowing = 0.0;
global.GHP_disableShearing = 0.0;
global.GHP_prevDisableShearing = 0.0;
global.GHP_disableShearingMPA = 0.0;
global.GHP_prevDisableShearingMPA = 0.0;

global.GHP_customShearsMPA = 0;
global.GHP_prevCustomShearsMPA = 0;
global.GHP_leftShearsStart = 0;
global.GHP_leftShearsEnd = 29;
global.GHP_rightShearsStart = 30;
global.GHP_rightShearsEnd = 59;
global.GHP_leftShearsRot = 7.5;
global.GHP_rightShearsRot = -7.5;

local disablePlanting = (GHP_prevDisablePlanting ~= GHP_disablePlanting)
local disableThrowing = (GHP_prevDisableThrowing ~= GHP_disableThrowing)
local disableShearing = (GHP_prevDisableShearing ~= GHP_disableShearing)
local disableShearingMPA = (GHP_disableShearingMPA ~= GHP_prevDisableShearingMPA)

local customShearsMPA = (GHP_customShearsMPA ~= GHP_prevCustomShearsMPA)

if not customShearsMPA then
	GHP_leftShearsStart = 0;
	GHP_leftShearsEnd = 29;
	GHP_rightShearsStart = 30;
	GHP_rightShearsEnd = 59;
	GHP_leftShearsRot = 7.5;
	GHP_rightShearsRot = -7.5;
end

GHP_prevCustomShearsMPA = GHP_customShearsMPA

global.pitchAngle = 0.0;
global.pitchAngleO = 0.0;
local ptAngle = (mainHand and pitchAngle) or pitchAngleO

if I:isIn(item, Tags:getVanillaTag("pickaxes")) then
	swingProgress = easeCustom(swingProgress)
else
	swingProgress = easeCustomSec(swingProgress)
end

local swing_rot
if swingProgress < 0.70016 then
    swing_rot = M:sin(M:clamp(swingProgress, 0, 0.308) * 5.1)
else
    swing_rot = M:sin(M:clamp(swingProgress, 0.70016, 1) * 5.1 - 2)
end

swing_rot = swing_rot * swing_rot * swing_rot
local swing = M:clamp(M:sin(swingProgress * 4.78), 0, 1)
local swing_hit = M:sin(M:clamp(swingProgress, 0.16561, 0.49422) * 4.78 * 2 + 4.7)

local pr = 0.9
local pt1 = 0.9
local pt2 = 0.9

if (I:isOf(P:getMainItem(player), Items:get("minecraft:pink_petals"))
	or I:isOf(P:getMainItem(player), Items:get("minecraft:wildflowers"))
	or I:isOf(P:getMainItem(player), Items:get("minecraft:leaf_litter"))
	--or (I:isIn(P:getMainItem(player), Tags:getVanillaTag("chicken_food")) and ${IncludeSeeds})
	)
	and ${Planting} and not disablePlanting
then
	if I:isOf(P:getMainItem(player), Items:get("minecraft:pink_petals")) or I:isOf(P:getMainItem(player), Items:get("minecraft:wildflowers")) or I:isOf(P:getMainItem(player), Items:get("minecraft:leaf_litter")) then
		pr = 1; pt1 = -1; pt2 = 1
	end
	M:rotateX(matrices, (20 * M:sin(equipProgress * equipProgress * equipProgress) + (ptAngle * 0.05)) * pr, 0.3 * l, -0.4, 0)
	M:rotateX(matrices, 25 * swing_hit * pr)
	M:rotateX(matrices, 10 * swing_rot * pr)
    if not I:isOf(P:getMainItem(player), Items:get("minecraft:pink_petals")) and not I:isOf(P:getMainItem(player), Items:get("minecraft:wildflowers")) and not I:isOf(P:getMainItem(player), Items:get("minecraft:leaf_litter")) then
		M:moveY(matrices, -0.05 * swing_rot * pt1)
        M:moveZ(matrices, 0.05 * swing_rot * pt2)
    end

    M:rotateX(matrices, 10 * swing_hit * pr)
    M:rotateX(matrices, 30 * swing_rot * pr)
    M:rotateX(matrices, -10 * swing_rot * pr)
    M:moveY(matrices, -0.05 * swing_rot * pt1)
    M:moveZ(matrices, 0.05 * swing_rot * pt2)
end

function bouncy_and_soft_drop(t, rise_time, start_val, peak_val, rise_power, fall_power, force)
    if t <= 0 then return start_val end
    if t >= 1 then return start_val end

    rise_power = rise_power or 2.0
    fall_power = fall_power or 3.0
    force = force or 2.5 

    -- PHASE 1:
    if t < rise_time then
        local rt = t / rise_time
        local ease
        local c1 = force
        local c2 = c1 * 1.525

        rt = rt * 2
        
        if rt < 1 then
            ease = (math.pow(rt, 2) * ((c2 + 1) * rt - c2)) / 2
        else
            rt = rt - 2
            ease = (math.pow(rt, 2) * ((c2 + 1) * rt + c2) + 2) / 2
        end
        
        return start_val + (peak_val - start_val) * ease

    -- PHASE 2:
    else
        local drop_duration = 1.0 - rise_time
        local rt = (t - rise_time) / drop_duration
        local ease
        rt = rt * 2
        if rt < 1 then
            ease = 0.5 * math.pow(rt, fall_power)
        else
            ease = 1 - 0.5 * math.pow(2 - rt, fall_power)
        end
        
        return peak_val + (start_val - peak_val) * ease
    end
end

if I:isOf(item, Items:get("minecraft:shears")) and ${Shearing} then
	if not disableShearing then
		-- cancelling
		M:rotateZ(matrices, -45)
		
		if not bl then
			M:rotateY(matrices, -180)
			M:moveZ(matrices, -0.1)
		end
		
		M:rotateX(matrices, -((P:getPitch(player) * -0.025) + ptAngle * 0.1), 0, -0.2, 0)
		
		M:rotateX(matrices, (20 * M:sin(equipProgress * equipProgress * equipProgress) + (ptAngle * 0.05)), 0.3 * l, -0.4, 0)

		M:rotateX(matrices, 25 * swing_hit)
		M:rotateX(matrices, 10 * swing_rot)
		M:moveY(matrices, 0.05 * swing_rot)
		M:moveZ(matrices, 0.05 * swing_rot)

		M:rotateX(matrices, 10 * swing_hit)
		M:rotateX(matrices, 30 * swing_rot)
		M:rotateX(matrices, -10 * swing_rot)
		M:moveY(matrices, 0.05 * swing_rot)
		M:moveZ(matrices, 0.05 * swing_rot)
		-- done cancel
		if mainHand then
			if not bl then
				M:moveZ(matrices, -0.3)
				M:moveY(matrices, 0.325)
				M:moveX(matrices, 0.2)
				M:moveZ(matrices, 0.1)
				M:rotateY(matrices, 180)
			end
			M:moveY(matrices, -0.275)
			M:moveZ(matrices, -0.2)
			M:moveX(matrices, 0.04*l)
			M:moveX(matrices, -0.04*(1-customMainSwing))
			M:rotateX(matrices, -60*l)
			M:rotateZ(matrices, -20)
			M:rotateY(matrices, -2.5*(1-customMainSwing))
			if not bl then
				M:rotateZ(matrices, 15*(1-customMainSwing))
			else
				M:rotateZ(matrices, 30*(1-customMainSwing))
			end
			M:scale(matrices, 1.5, 1.5, 1.5)
		else
			M:rotateX(matrices, -90)
			M:moveZ(matrices, -0.2)
			M:scale(matrices, 1.3, 1.4, 1.3)
		end
	end
	if animator ~= nil and not disableShearingMPA then
		animator:rotateZ(GHP_leftShearsStart,GHP_leftShearsEnd,bouncy_and_soft_drop(customSwing, 0.275, 0, GHP_leftShearsRot, 2, 3, 5),0.75,0,0)
		animator:rotateZ(GHP_rightShearsStart,GHP_rightShearsEnd,bouncy_and_soft_drop(customSwing, 0.275, 0, GHP_rightShearsRot, 2, 3, 5),0.25,0,0)
	end
end
