#version 150

vec4 linear_fog(vec4 inColor, float vertexDistance, float fogStart, float fogEnd, vec4 fogColor) {
    if (vertexDistance <= fogStart) {
        return inColor;
    }

    // Normal fog: stronger as distance increases
    float fogValue = vertexDistance < fogEnd 
                     ? smoothstep(fogStart, fogEnd, vertexDistance) 
                     : 1.0;

    // Blend RGB toward fog color
    vec3 finalRGB = mix(inColor.rgb, fogColor.rgb, fogValue);

    // Fade alpha toward 0 independently
    float finalA = mix(inColor.a, 0.0, fogValue);

    return vec4(finalRGB, finalA);
}

float linear_fog_fade(float vertexDistance, float fogStart, float fogEnd) {
    if (vertexDistance <= fogStart) {
        return 1.0;
    } else if (vertexDistance >= fogEnd) {
        return 0.0;
    }

    return smoothstep(fogEnd, fogStart, vertexDistance);
}

float fog_distance(vec3 pos, int shape) {
    if (shape == 0) {
        return length(pos);
    } else {
        float distXZ = length(pos.xz);
        float distY = abs(pos.y);
        return max(distXZ, distY);
    }
}
