local l = (bl and 1) or -1
local d = (bl and 1) or -0.43
local a = (bl and 1) or 0.8
global.fall_l = 0.0; 
global.pitchAngle = 0.0;
global.pitchAngleO = 0.0;
global.yawAngle = 0.0;
global.yawAngleO = 0.0;

local ptAngle = (mainHand and pitchAngle) or pitchAngleO
local ywAngle = (mainHand and yawAngle) or yawAngleO

local translateIds = {
    "minecraft:torch",
    "minecraft:soul_torch",
    "minecraft:redstone_torch"
}

local flameParticles = {
    "textures/particle/flame1.png",
    "textures/particle/flame2.png",
    "textures/particle/flame3.png",
    "textures/particle/flame4.png",
    "textures/particle/flame5.png",
    "textures/particle/flame6.png",
    "textures/particle/flame7.png",
    "textures/particle/flame8.png",
    "textures/particle/flame9.png",
    "textures/particle/flame10.png",
    "textures/particle/flame11.png",
    "textures/particle/flame12.png",
    "textures/particle/flame13.png",
    "textures/particle/flame14.png",
    "textures/particle/flame15.png",
    "textures/particle/flame16.png",
    "textures/particle/flame17.png",
    "textures/particle/flame18.png",
    "textures/particle/flame19.png",
    "textures/particle/flame20.png",
    "textures/particle/flame21.png",
    "textures/particle/flame22.png"
}

local soulParticles = {
    "textures/particle/soul1.png",
    "textures/particle/soul2.png",
    "textures/particle/soul3.png",
    "textures/particle/soul4.png",
    "textures/particle/soul5.png",
    "textures/particle/soul6.png",
    "textures/particle/soul7.png",
    "textures/particle/soul8.png",
    "textures/particle/soul9.png",
    "textures/particle/soul10.png",
    "textures/particle/soul11.png",
    "textures/particle/soul12.png",
    "textures/particle/soul13.png",
    "textures/particle/soul14.png",
    "textures/particle/soul15.png",
    "textures/particle/soul16.png",
    "textures/particle/soul17.png",
    "textures/particle/soul18.png",
    "textures/particle/soul19.png",
    "textures/particle/soul20.png",
    "textures/particle/soul21.png",
    "textures/particle/soul22.png",
}

-- move torches down
do
    local should_translate = false
    for _, id in ipairs(translateIds) do
        if I:isOf(item, Items:get(id)) then
            should_translate = true
            break
        end
    end
    if should_translate then
        M:moveY(matrices, -0.085)
        M:moveX(matrices, 0.07 * l)


        M:rotateY(matrices, -5 * l)
        M:rotateZ(matrices, 0 * l)

        M:scale(matrices, 1.35, 1.35, 1.35)
        I:setTranslate(item, true)
    end
end

-- torch particles
if I:isOf(item, Items:get("minecraft:torch")) then
    local age = P:getAge(player)
    local frameIndex = math.floor(age * 0.45) % #flameParticles
    local flameTexture = Texture:of("minecraft", flameParticles[frameIndex + 1]) -- +1 for 1-based indexing

    particleManager:addParticle(
        particles,
        false,
        0.88 * d,
        0.62,
        0.3,
        0, 0, 0, 0, 0, 0, 0, 0, 0,
        2,
        flameTexture,
        "ITEM",
        hand,
        "SPAWN",
        "CUTOUT_L",
        0,
        255
    )
end

if I:isOf(item, Items:get("minecraft:torch")) then
    particleManager:addParticle(particles,
        false,
        0.75 * l,       
        0.50,      
        0.15,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        2.5, Texture:of("minecraft", "textures/particle/w_glow.png"), "ITEM", hand, "SPAWN", "ADDITIVE", 0, 200 + (20 * M:sin(P:getAge(player) * 0.2)))
end

-- soul torch particles
if I:isOf(item, Items:get("minecraft:soul_torch")) then
    local age = P:getAge(player)
    local frameIndex = math.floor(age * 0.45) % #soulParticles
    local flameTexture = Texture:of("minecraft", soulParticles[frameIndex + 1]) -- +1 for 1-based indexing

    particleManager:addParticle(
        particles,
        false,
        0.88 * d,
        0.62,
        0.3,
        0, 0, 0, 0, 0, 0, 0, 0, 0,
        2,
        flameTexture,
        "ITEM",
        hand,
        "SPAWN",
        "CUTOUT_L",
        0,
        255
    )
end

if I:isOf(item, Items:get("minecraft:soul_torch")) then
    particleManager:addParticle(particles,
        false,
       0.75 * l,       
        0.50,      
        0.15,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        2.5, Texture:of("minecraft", "textures/particle/b_glow.png"), "ITEM", hand, "SPAWN", "ADDITIVE", 0, 200 + (20 * M:sin(P:getAge(player) * 0.2)))
end

-- redstone particles
if I:isOf(item, Items:get("minecraft:redstone_torch")) then
    particleManager:addParticle(particles,
        false,
        0.75 * l,       
        0.35,      
        0.20,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        0,
        2.5, Texture:of("minecraft", "textures/particle/r_glow.png"), "ITEM", hand, "SPAWN", "ADDITIVE", 0, 200 + (20 * M:sin(P:getAge(player) * 0.2)))
end

local itemIds = {"minecraft:repeater", "minecraft:comparator"}
for _, id in ipairs(itemIds) do
    renderAsBlock:put(id, false)
end

-- comp and rep
if (
    I:isOf(item, Items:get("minecraft:repeater")) or
    I:isOf(item, Items:get("minecraft:comparator")) 

) then
    M:moveY(matrices, -0.1)
    M:moveZ(matrices, 0.15)
    M:moveX(matrices, 0.15 * l)
    M:rotateX(matrices, -85)
    M:rotateZ(matrices, 35 * l)
    M:rotateY(matrices, 7 * l)
    M:scale(matrices, 1.35, 1.35, 1.35)
end